/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.ExternalFileTypeEntryEditor;

public class ExternalFileTypeEditor
extends JDialog {
    private JFrame frame = null;
    private JDialog dialog = null;
    private ArrayList<ExternalFileType> fileTypes;
    private JTable table;
    private ExternalFileTypeEntryEditor entryEditor = null;
    private FileTypeTableModel tableModel;
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private final JButton cancel = new JButton(Globals.lang("Cancel"));
    private final JButton add = new JButton(GUIGlobals.getImage("add"));
    private final JButton remove = new JButton(GUIGlobals.getImage("remove"));
    private final JButton edit = new JButton(GUIGlobals.getImage("edit"));
    private final JButton toDefaults = new JButton(Globals.lang("Default"));
    private final EditListener editListener = new EditListener();

    private ExternalFileTypeEditor(JFrame jFrame) {
        super(jFrame, Globals.lang("Manage external file types"), true);
        this.frame = jFrame;
        this.init();
    }

    private ExternalFileTypeEditor(JDialog jDialog) {
        super(jDialog, Globals.lang("Manage external file types"), true);
        this.dialog = jDialog;
        this.init();
    }

    private void setValues() {
        ExternalFileType[] externalFileTypeArray;
        this.fileTypes.clear();
        for (ExternalFileType externalFileType : externalFileTypeArray = Globals.prefs.getExternalFileTypeSelection()) {
            this.fileTypes.add(externalFileType.copy());
        }
        Collections.sort(this.fileTypes);
    }

    private void storeSettings() {
        Globals.prefs.setExternalFileTypes(this.fileTypes);
    }

    private void init() {
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFileTypeEditor.this.storeSettings();
                ExternalFileTypeEditor.this.dispose();
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFileTypeEditor.this.dispose();
            }
        };
        this.cancel.addActionListener(abstractAction);
        this.toDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<ExternalFileType> list = Globals.prefs.getDefaultExternalFileTypes();
                ExternalFileTypeEditor.this.fileTypes.clear();
                ExternalFileTypeEditor.this.fileTypes.addAll(list);
                Collections.sort(ExternalFileTypeEditor.this.fileTypes);
                ExternalFileTypeEditor.this.tableModel.fireTableDataChanged();
            }
        });
        this.add.addActionListener(new AddListener());
        this.remove.addActionListener(new RemoveListener());
        this.edit.addActionListener(this.editListener);
        this.fileTypes = new ArrayList();
        this.setValues();
        this.tableModel = new FileTypeTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setDefaultRenderer(ImageIcon.class, new IconRenderer());
        this.table.addMouseListener(new TableClickListener());
        this.table.getColumnModel().getColumn(0).setMaxWidth(24);
        this.table.getColumnModel().getColumn(0).setMinWidth(24);
        this.table.getColumnModel().getColumn(1).setMinWidth(170);
        this.table.getColumnModel().getColumn(2).setMinWidth(60);
        this.table.getColumnModel().getColumn(3).setMinWidth(100);
        this.table.getColumnModel().getColumn(0).setResizable(false);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "Center");
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addButton((JComponent)this.add);
        buttonStackBuilder.addButton((JComponent)this.remove);
        buttonStackBuilder.addButton((JComponent)this.edit);
        buttonStackBuilder.addRelatedGap();
        buttonStackBuilder.addButton((JComponent)this.toDefaults);
        jPanel.add((Component)buttonStackBuilder.getPanel(), "East");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)this.cancel);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.pack();
        ActionMap actionMap = jPanel.getActionMap();
        InputMap inputMap = jPanel.getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        actionMap = buttonBarBuilder.getPanel().getActionMap();
        inputMap = buttonBarBuilder.getPanel().getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        if (this.frame != null) {
            this.setLocationRelativeTo(this.frame);
        } else {
            this.setLocationRelativeTo(this.dialog);
        }
    }

    private ExternalFileTypeEntryEditor getEditor(ExternalFileType externalFileType) {
        if (this.entryEditor == null) {
            this.entryEditor = new ExternalFileTypeEntryEditor(this, externalFileType);
        } else {
            this.entryEditor.setEntry(externalFileType);
        }
        return this.entryEditor;
    }

    public static AbstractAction getAction(JabRefFrame jabRefFrame) {
        return new EditExternalFileTypesAction(jabRefFrame);
    }

    public static AbstractAction getAction(JDialog jDialog) {
        return new EditExternalFileTypesAction(jDialog);
    }

    public static class EditExternalFileTypesAction
    extends MnemonicAwareAction {
        private JabRefFrame frame = null;
        private JDialog dialog = null;
        ExternalFileTypeEditor editor = null;

        public EditExternalFileTypesAction(JabRefFrame jabRefFrame) {
            this.putValue("Name", "Manage external file types");
            this.frame = jabRefFrame;
        }

        public EditExternalFileTypesAction(JDialog jDialog) {
            this.putValue("Name", "Manage external file types");
            this.dialog = jDialog;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.editor == null) {
                this.editor = this.frame != null ? new ExternalFileTypeEditor(this.frame) : new ExternalFileTypeEditor(this.dialog);
            }
            this.editor.setValues();
            this.editor.setVisible(true);
            if (this.frame != null && this.frame.basePanel() != null) {
                this.frame.basePanel().mainTable.repaint();
            }
        }
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        private void handleClick(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ExternalFileTypeEditor.this.editListener.actionPerformed(null);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.handleClick(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.handleClick(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.handleClick(mouseEvent);
        }
    }

    private class FileTypeTableModel
    extends AbstractTableModel {
        private FileTypeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return ExternalFileTypeEditor.this.fileTypes.size();
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return Globals.lang("Name");
                }
                case 2: {
                    return Globals.lang("Extension");
                }
                case 3: {
                    return Globals.lang("MIME type");
                }
                case 4: {
                    return Globals.lang("Application");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return ImageIcon.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ExternalFileType externalFileType = (ExternalFileType)ExternalFileTypeEditor.this.fileTypes.get(n);
            switch (n2) {
                case 0: {
                    return externalFileType.getIcon();
                }
                case 1: {
                    return externalFileType.getName();
                }
                case 2: {
                    return externalFileType.getExtension();
                }
                case 3: {
                    return externalFileType.getMimeType();
                }
                case 4: {
                    return externalFileType.getOpenWith();
                }
            }
            return null;
        }
    }

    class IconRenderer
    implements TableCellRenderer {
        final JLabel lab = new JLabel();

        IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.lab.setText(null);
            this.lab.setIcon((ImageIcon)object);
            return this.lab;
        }
    }

    class EditListener
    implements ActionListener {
        EditListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ExternalFileTypeEditor.this.table.getSelectedRows();
            if (nArray.length != 1) {
                return;
            }
            ExternalFileTypeEditor.this.getEditor((ExternalFileType)ExternalFileTypeEditor.this.fileTypes.get(nArray[0])).setVisible(true);
            if (ExternalFileTypeEditor.this.entryEditor.okPressed()) {
                ExternalFileTypeEditor.this.tableModel.fireTableDataChanged();
            }
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = ExternalFileTypeEditor.this.table.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                ExternalFileTypeEditor.this.fileTypes.remove(nArray[n]);
            }
            ExternalFileTypeEditor.this.tableModel.fireTableDataChanged();
            if (ExternalFileTypeEditor.this.fileTypes.size() > 0) {
                n = Math.min(nArray[0], ExternalFileTypeEditor.this.fileTypes.size() - 1);
                ExternalFileTypeEditor.this.table.setRowSelectionInterval(n, n);
            }
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExternalFileType externalFileType = new ExternalFileType("", "", "", "", "new");
            ExternalFileTypeEditor.this.getEditor(externalFileType).setVisible(true);
            if (ExternalFileTypeEditor.this.entryEditor.okPressed()) {
                ExternalFileTypeEditor.this.fileTypes.add(externalFileType);
                ExternalFileTypeEditor.this.tableModel.fireTableDataChanged();
            }
        }
    }
}

