/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.EntryEditorTabList;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.PostOpenAction;
import net.sf.jabref.util.Util;

public class FileLinksUpgradeWarning
implements PostOpenAction {
    private static final String[] FIELDS_TO_LOOK_FOR = new String[]{"pdf", "ps"};

    @Override
    public boolean isActionNecessary(ParserResult parserResult) {
        if (!Globals.prefs.getBoolean("showFileLinksUpgradeWarning")) {
            return false;
        }
        if (parserResult.getJabrefMajorVersion() < 0) {
            return false;
        }
        if (parserResult.getJabrefMajorVersion() < 2) {
            return true;
        }
        if (parserResult.getJabrefMajorVersion() > 2) {
            return false;
        }
        return parserResult.getJabrefMinorVersion() <= 2;
    }

    @Override
    public void performAction(BasePanel basePanel, ParserResult parserResult) {
        boolean bl;
        boolean bl2 = !Globals.prefs.getBoolean("fileColumn") || !this.showsFileInGenFields();
        boolean bl3 = this.linksFound(parserResult.getDatabase(), FIELDS_TO_LOOK_FOR);
        boolean bl4 = bl = !Globals.prefs.hasKey("fileDirectory") && (Globals.prefs.hasKey("pdfDirectory") || Globals.prefs.hasKey("psDirectory"));
        if (!(bl3 || bl2 || bl)) {
            return;
        }
        JCheckBox jCheckBox = new JCheckBox(Globals.lang("Change table column and General fields settings to use the new feature"), bl2);
        JCheckBox jCheckBox2 = new JCheckBox(Globals.lang("Upgrade old external file links to use the new feature"), bl3);
        JCheckBox jCheckBox3 = new JCheckBox(Globals.lang("Set main external file directory") + ":", bl);
        JTextField jTextField = new JTextField(30);
        JCheckBox jCheckBox4 = new JCheckBox(Globals.lang("Do not show these options in the future"), false);
        JPanel jPanel = new JPanel();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref", ""), jPanel);
        defaultFormBuilder.append(new JLabel("<html>" + Globals.lang("This database was written using an older version of JabRef.") + "<br>" + Globals.lang("The current version features a new way of handling links to external files.<br>To take advantage of this, your links must be changed into the new format, and<br>JabRef must be configured to show the new links.") + "<p>" + Globals.lang("Do you want JabRef to do the following operations?") + "</html>"));
        defaultFormBuilder.nextLine();
        if (bl2) {
            defaultFormBuilder.append(jCheckBox);
            defaultFormBuilder.nextLine();
        }
        if (bl3) {
            defaultFormBuilder.append(jCheckBox2);
            defaultFormBuilder.nextLine();
        }
        if (bl) {
            if (Globals.prefs.hasKey("pdfDirectory")) {
                jTextField.setText(Globals.prefs.get("pdfDirectory"));
            } else {
                jTextField.setText(Globals.prefs.get("psDirectory"));
            }
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jCheckBox3);
            jPanel2.add(jTextField);
            JButton jButton = new JButton(Globals.lang("Browse"));
            jButton.addActionListener(BrowseAction.buildForDir(jTextField));
            jPanel2.add(jButton);
            defaultFormBuilder.append(jPanel2);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append("");
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jCheckBox4);
        int n = JOptionPane.showConfirmDialog(basePanel.frame(), jPanel, Globals.lang("Upgrade file"), 0);
        if (jCheckBox4.isSelected()) {
            Globals.prefs.putBoolean("showFileLinksUpgradeWarning", false);
        }
        if (n == 0) {
            this.makeChanges(basePanel, parserResult, jCheckBox.isSelected(), jCheckBox2.isSelected(), jCheckBox3.isSelected() ? jTextField.getText() : null);
        }
    }

    private boolean linksFound(BibtexDatabase bibtexDatabase, String[] stringArray) {
        for (BibtexEntry bibtexEntry : bibtexDatabase.getEntries()) {
            for (String string : stringArray) {
                if (bibtexEntry.getField(string) == null) continue;
                return true;
            }
        }
        return false;
    }

    private void makeChanges(BasePanel basePanel, ParserResult parserResult, boolean bl, boolean bl2, String string) {
        Object object;
        if (bl2) {
            object = Util.upgradePdfPsToFile(parserResult.getDatabase(), FIELDS_TO_LOOK_FOR);
            basePanel.undoManager.addEdit((UndoableEdit)object);
            basePanel.markBaseChanged();
        }
        if (string != null) {
            Globals.prefs.put("fileDirectory", string);
        }
        if (bl) {
            Globals.prefs.putBoolean("pdfColumn", Boolean.FALSE);
            Globals.prefs.putBoolean("fileColumn", Boolean.TRUE);
            if (!this.showsFileInGenFields()) {
                object = Globals.prefs.get("customTabFields_0");
                StringBuilder stringBuilder = new StringBuilder((String)object);
                if (((String)object).length() > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append("file");
                Globals.prefs.put("customTabFields_0", stringBuilder.toString());
                Globals.prefs.updateEntryEditorTabList();
                basePanel.frame().removeCachedEntryEditors();
            }
            basePanel.frame().setupAllTables();
        }
    }

    private boolean showsFileInGenFields() {
        boolean bl = false;
        EntryEditorTabList entryEditorTabList = Globals.prefs.getEntryEditorTabList();
        block0: for (int i = 0; i < entryEditorTabList.getTabCount(); ++i) {
            List<String> list = entryEditorTabList.getTabFields(i);
            for (String string : list) {
                if (!string.equals("file")) continue;
                bl = true;
                break block0;
            }
        }
        return bl;
    }
}

