/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.FileListEditor;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.Util;

public class MoveFileAction
extends AbstractAction {
    private final JabRefFrame frame;
    private final EntryEditor eEditor;
    private final FileListEditor editor;
    private final boolean toFileDir;

    public MoveFileAction(JabRefFrame jabRefFrame, EntryEditor entryEditor, FileListEditor fileListEditor, boolean bl) {
        this.frame = jabRefFrame;
        this.eEditor = entryEditor;
        this.editor = fileListEditor;
        this.toFileDir = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block27: {
            int n = this.editor.getSelectedRow();
            if (n == -1) {
                return;
            }
            FileListEntry fileListEntry = this.editor.getTableModel().getEntry(n);
            String string = fileListEntry.getLink();
            boolean bl = string.toLowerCase().startsWith("http");
            if (bl) {
                // empty if block
            }
            String[] stringArray = this.frame.basePanel().metaData().getFileDirectory("file");
            int n2 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!new File(stringArray[i]).exists()) continue;
                n2 = i;
                break;
            }
            if (n2 < 0) {
                JOptionPane.showMessageDialog(this.frame, Globals.lang("File_directory_is_not_set_or_does_not_exist!"), Globals.lang("Move/Rename file"), 0);
                return;
            }
            File file = new File(string);
            if (!file.isAbsolute()) {
                file = FileUtil.expandFilename(string, stringArray);
            }
            if (file != null && file.exists()) {
                String string2;
                String string3 = null;
                if (fileListEntry.getType() != null) {
                    string3 = "." + fileListEntry.getType().getExtension();
                }
                File file2 = null;
                boolean bl2 = true;
                while (bl2) {
                    String string4;
                    bl2 = false;
                    if (this.toFileDir) {
                        string2 = Util.getLinkedFileName(this.eEditor.getDatabase(), this.eEditor.getEntry()).concat(".").concat(fileListEntry.getType().extension);
                        CheckBoxMessage checkBoxMessage = new CheckBoxMessage(Globals.lang("Move file to file directory?"), Globals.lang("Rename to '%0'", string2), Globals.prefs.getBoolean("renameOnMoveFileToFileDir"));
                        int n3 = !string2.equals(file.getName()) ? JOptionPane.showConfirmDialog(this.frame, checkBoxMessage, Globals.lang("Move/Rename file"), 0) : JOptionPane.showConfirmDialog(this.frame, Globals.lang("Move file to file directory?"), Globals.lang("Move/Rename file"), 0);
                        if (n3 != 0) {
                            return;
                        }
                        Globals.prefs.putBoolean("renameOnMoveFileToFileDir", checkBoxMessage.isSelected());
                        StringBuilder stringBuilder = new StringBuilder(stringArray[n2]);
                        if (!stringArray[n2].endsWith(File.separator)) {
                            stringBuilder.append(File.separator);
                        }
                        if (checkBoxMessage.isSelected()) {
                            stringBuilder.append(string2);
                        } else {
                            stringBuilder.append(file.getName());
                        }
                        string4 = stringBuilder.toString();
                    } else {
                        string4 = FileDialogs.getNewFile(this.frame, file, string3, 1, false);
                    }
                    if (string4 == null) {
                        return;
                    }
                    file2 = new File(string4);
                    if (!file2.exists() || JOptionPane.showConfirmDialog(this.frame, "'" + file2.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Move/Rename file"), 2) == 0) continue;
                    if (!this.toFileDir) {
                        bl2 = true;
                        continue;
                    }
                    return;
                }
                if (!file2.equals(file)) {
                    try {
                        boolean bl3 = file.renameTo(file2);
                        if (!bl3) {
                            bl3 = FileUtil.copyFile(file, file2, true);
                        }
                        if (bl3) {
                            file.delete();
                            string2 = new File(stringArray[n2]).getCanonicalPath();
                            if (file2.getCanonicalPath().startsWith(string2)) {
                                if (file2.getCanonicalPath().length() > string2.length() && file2.getCanonicalPath().charAt(string2.length()) == File.separatorChar) {
                                    fileListEntry.setLink(file2.getCanonicalPath().substring(1 + string2.length()));
                                } else {
                                    fileListEntry.setLink(file2.getCanonicalPath().substring(string2.length()));
                                }
                            } else {
                                fileListEntry.setLink(file2.getCanonicalPath());
                            }
                            this.eEditor.updateField(this.editor);
                            this.frame.output(Globals.lang("File moved"));
                            break block27;
                        }
                        JOptionPane.showMessageDialog(this.frame, Globals.lang("Move file failed"), Globals.lang("Move/Rename file"), 0);
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace();
                        JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not move file") + ": " + securityException.getMessage(), Globals.lang("Move/Rename file"), 0);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not move file") + ": " + iOException.getMessage(), Globals.lang("Move/Rename file"), 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not find file '%0'.", fileListEntry.getLink()), Globals.lang("File not found"), 0);
            }
        }
    }
}

