/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToTeXstudio
implements PushToApplication {
    private final String defaultCiteCommand = "\\cite";
    private JPanel settings = null;
    private final JTextField citeCommand = new JTextField(30);
    private final JTextField progPath = new JTextField(30);
    private boolean couldNotConnect = false;
    private boolean couldNotRunClient = false;

    @Override
    public String getName() {
        return Globals.lang("Insert selected citations into TeXstudio");
    }

    @Override
    public String getApplicationName() {
        return "TeXstudio";
    }

    @Override
    public String getTooltip() {
        return Globals.lang("Push selection to TeXstudio");
    }

    @Override
    public Icon getIcon() {
        return GUIGlobals.getImage("texstudio");
    }

    @Override
    public String getKeyStrokeName() {
        return "Push to TeXstudio";
    }

    private String defaultProgramPath() {
        if (Globals.ON_WIN) {
            String string = System.getenv("ProgramFiles(x86)");
            if (string == null) {
                string = System.getenv("ProgramFiles");
            }
            return string + "\\texstudio\\texstudio.exe";
        }
        return "texstudio";
    }

    @Override
    public JPanel getSettingsPanel() {
        String string;
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        if ((string = Globals.prefs.get("citeCommandTeXstudio")) == null) {
            string = "\\cite";
        }
        this.citeCommand.setText(string);
        String string2 = Globals.prefs.get("TeXstudioPath");
        if (string2 == null) {
            string2 = this.defaultProgramPath();
        }
        this.progPath.setText(string2);
        return this.settings;
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("citeCommandTeXstudio", this.citeCommand.getText().trim());
        Globals.prefs.put("TeXstudioPath", this.progPath.getText().trim());
    }

    private void initSettingsPanel() {
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder.append(Globals.lang("Cite command") + ":");
        defaultFormBuilder.append(this.citeCommand);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Path to TeXstudio") + ":");
        defaultFormBuilder.append(this.progPath);
        this.settings = defaultFormBuilder.getPanel();
    }

    @Override
    public void pushEntries(BibtexDatabase bibtexDatabase, BibtexEntry[] bibtexEntryArray, String string, MetaData metaData) {
        String string2;
        this.couldNotConnect = false;
        this.couldNotRunClient = false;
        String string3 = Globals.prefs.get("citeCommandTeXstudio");
        if (string3 == null) {
            string3 = "\\cite";
        }
        if ((string2 = Globals.prefs.get("TeXstudioPath")) == null) {
            string2 = this.defaultProgramPath();
        }
        try {
            String[] stringArray;
            if (Globals.ON_WIN) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = string2;
                stringArray2[1] = "--insert-cite";
                stringArray = stringArray2;
                stringArray2[2] = string3 + "{" + string + "}";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = string2;
                stringArray3[1] = "--insert-cite";
                stringArray = stringArray3;
                stringArray3[2] = string3 + "{" + string + "}";
            }
            String[] stringArray4 = stringArray;
            final Process process = Runtime.getRuntime().exec(stringArray4);
            System.out.println(string);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = process.getErrorStream();
                    StringBuilder stringBuilder = new StringBuilder();
                    try {
                        int n;
                        while ((n = inputStream.read()) != -1) {
                            stringBuilder.append((char)n);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (stringBuilder.toString().trim().length() > 0) {
                        PushToTeXstudio.this.couldNotConnect = true;
                    }
                }
            };
            JabRefExecutorService.INSTANCE.executeAndWait(runnable);
        }
        catch (IOException iOException) {
            this.couldNotRunClient = true;
        }
    }

    @Override
    public void operationCompleted(BasePanel basePanel) {
        if (this.couldNotConnect) {
            JOptionPane.showMessageDialog(basePanel.frame(), "TeXstudio: could not connect", Globals.lang("Error"), 0);
        } else if (this.couldNotRunClient) {
            String string = Globals.prefs.get("TeXstudioPath");
            if (string == null) {
                string = this.defaultProgramPath();
            }
            JOptionPane.showMessageDialog(basePanel.frame(), "TeXstudio: " + Globals.lang("Program '%0' not found", string), Globals.lang("Error"), 0);
        } else {
            basePanel.output(Globals.lang("Pushed citations to TeXstudio"));
        }
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }
}

