/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToWinEdt
implements PushToApplication {
    private boolean couldNotCall = false;
    private boolean notDefined = false;
    private JPanel settings = null;
    private final JTextField winEdtPath = new JTextField(30);
    private final JTextField citeCommand = new JTextField(30);

    @Override
    public String getName() {
        return Globals.lang("Insert selected citations into WinEdt");
    }

    @Override
    public String getApplicationName() {
        return "WinEdt";
    }

    @Override
    public String getTooltip() {
        return Globals.lang("Push selection to WinEdt");
    }

    @Override
    public Icon getIcon() {
        return GUIGlobals.getImage("winedt");
    }

    @Override
    public String getKeyStrokeName() {
        return "Push to WinEdt";
    }

    @Override
    public void pushEntries(BibtexDatabase bibtexDatabase, BibtexEntry[] bibtexEntryArray, String string, MetaData metaData) {
        this.couldNotCall = false;
        this.notDefined = false;
        String string2 = Globals.prefs.get("winEdtPath");
        if (string2 == null || string2.trim().length() == 0) {
            this.notDefined = true;
            return;
        }
        try {
            Runtime.getRuntime().exec(new String[]{string2, "\"[InsText('" + Globals.prefs.get("citeCommandWinEdt") + "{" + string.replaceAll("'", "''") + "}');]\""});
        }
        catch (IOException iOException) {
            this.couldNotCall = true;
            iOException.printStackTrace();
        }
    }

    @Override
    public void operationCompleted(BasePanel basePanel) {
        if (this.notDefined) {
            basePanel.output(Globals.lang("Error") + ": " + Globals.lang("Path to %0 not defined", this.getApplicationName()) + ".");
        } else if (this.couldNotCall) {
            basePanel.output(Globals.lang("Error") + ": " + Globals.lang("Could not call executable") + " '" + Globals.prefs.get("winEdtPath") + "'.");
        } else {
            Globals.lang("Pushed citations to WinEdt");
        }
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.winEdtPath.setText(Globals.prefs.get("winEdtPath"));
        this.citeCommand.setText(Globals.prefs.get("citeCommandWinEdt"));
        return this.settings;
    }

    private void initSettingsPanel() {
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder.append(new JLabel(Globals.lang("Path to WinEdt.exe") + ":"));
        defaultFormBuilder.append(this.winEdtPath);
        BrowseAction browseAction = BrowseAction.buildForFile(this.winEdtPath);
        JButton jButton = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(browseAction);
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Cite command") + ":");
        defaultFormBuilder.append(this.citeCommand);
        this.settings = defaultFormBuilder.getPanel();
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("winEdtPath", this.winEdtPath.getText());
        Globals.prefs.put("citeCommandWinEdt", this.citeCommand.getText());
    }
}

