/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.Util;
import net.sf.jabref.util.XMPUtil;

public class WriteXMPAction
extends AbstractWorker {
    private final BasePanel panel;
    private BibtexEntry[] entries;
    private BibtexDatabase database;
    private OptionsDialog optDiag;
    private boolean goOn = true;
    private int skipped;
    private int entriesChanged;
    private int errors;

    public WriteXMPAction(BasePanel basePanel) {
        this.panel = basePanel;
    }

    @Override
    public void init() {
        this.database = this.panel.getDatabase();
        this.entries = this.panel.getSelectedEntries();
        if (this.entries.length == 0) {
            Collection<BibtexEntry> collection = this.database.getEntries();
            this.entries = collection.toArray(new BibtexEntry[collection.size()]);
            if (this.entries.length == 0) {
                JOptionPane.showMessageDialog(this.panel, Globals.lang("This operation requires at least one entry."), Globals.lang("Write XMP-metadata"), 0);
                this.goOn = false;
                return;
            }
            int n = JOptionPane.showConfirmDialog(this.panel, Globals.lang("Write XMP-metadata for all PDFs in current database?"), Globals.lang("Write XMP-metadata"), 1, 3);
            if (n != 0) {
                this.goOn = false;
                return;
            }
        }
        this.skipped = 0;
        this.entriesChanged = 0;
        this.errors = 0;
        if (this.optDiag == null) {
            this.optDiag = new OptionsDialog(this.panel.frame());
        }
        this.optDiag.open();
        this.panel.output(Globals.lang("Writing XMP metadata..."));
    }

    @Override
    public void run() {
        if (!this.goOn) {
            return;
        }
        for (BibtexEntry bibtexEntry : this.entries) {
            String[] stringArray;
            ArrayList<File> arrayList = new ArrayList<File>();
            String string = bibtexEntry.getField("pdf");
            File file = FileUtil.expandFilename(string, stringArray = this.panel.metaData().getFileDirectory("pdf"));
            if (file != null) {
                arrayList.add(file);
            }
            stringArray = this.panel.metaData().getFileDirectory("file");
            String string2 = bibtexEntry.getField("file");
            if (string2 != null) {
                FileListTableModel fileListTableModel = new FileListTableModel();
                fileListTableModel.setContent(string2);
                for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
                    FileListEntry fileListEntry = fileListTableModel.getEntry(i);
                    if (fileListEntry.getType() == null || !fileListEntry.getType().getName().toLowerCase().equals("pdf") || (file = FileUtil.expandFilename(fileListEntry.getLink(), stringArray)) == null) continue;
                    arrayList.add(file);
                }
            }
            this.optDiag.progressArea.append(bibtexEntry.getCiteKey() + "\n");
            if (arrayList.size() == 0) {
                ++this.skipped;
                this.optDiag.progressArea.append("  " + Globals.lang("Skipped - No PDF linked") + ".\n");
            } else {
                for (File file2 : arrayList) {
                    if (!file2.exists()) {
                        ++this.skipped;
                        this.optDiag.progressArea.append("  " + Globals.lang("Skipped - PDF does not exist") + ":\n");
                        this.optDiag.progressArea.append("    " + file2.getPath() + "\n");
                        continue;
                    }
                    try {
                        XMPUtil.writeXMP(file2, bibtexEntry, this.database);
                        this.optDiag.progressArea.append("  " + Globals.lang("Ok") + ".\n");
                        ++this.entriesChanged;
                    }
                    catch (Exception exception) {
                        this.optDiag.progressArea.append("  " + Globals.lang("Error while writing") + " '" + file2.getPath() + "':\n");
                        this.optDiag.progressArea.append("    " + exception.getLocalizedMessage() + "\n");
                        ++this.errors;
                    }
                }
            }
            if (!this.optDiag.canceled) continue;
            this.optDiag.progressArea.append("\n" + Globals.lang("Operation canceled.\n"));
            break;
        }
        this.optDiag.progressArea.append("\n" + Globals.lang("Finished writing XMP for %0 file (%1 skipped, %2 errors).", String.valueOf(this.entriesChanged), String.valueOf(this.skipped), String.valueOf(this.errors)));
        this.optDiag.done();
    }

    @Override
    public void update() {
        if (!this.goOn) {
            return;
        }
        this.panel.output(Globals.lang("Finished writing XMP for %0 file (%1 skipped, %2 errors).", String.valueOf(this.entriesChanged), String.valueOf(this.skipped), String.valueOf(this.errors)));
    }

    class OptionsDialog
    extends JDialog {
        private static final long serialVersionUID = 7459164400811785958L;
        final JButton okButton;
        final JButton cancelButton;
        boolean canceled;
        final JTextArea progressArea;

        public OptionsDialog(JFrame jFrame) {
            super(jFrame, Globals.lang("Writing XMP metadata for selected entries..."), false);
            this.okButton = new JButton(Globals.lang("Ok"));
            this.cancelButton = new JButton(Globals.lang("Cancel"));
            this.okButton.setEnabled(false);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.this.dispose();
                }
            });
            AbstractAction abstractAction = new AbstractAction(){
                private static final long serialVersionUID = -338601477652815366L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.this.canceled = true;
                }
            };
            this.cancelButton.addActionListener(abstractAction);
            InputMap inputMap = this.cancelButton.getInputMap(2);
            ActionMap actionMap = this.cancelButton.getActionMap();
            inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
            actionMap.put("close", abstractAction);
            this.progressArea = new JTextArea(15, 60);
            JScrollPane jScrollPane = new JScrollPane(this.progressArea, 22, 31);
            Dimension dimension = this.progressArea.getPreferredSize();
            dimension.height += jScrollPane.getHorizontalScrollBar().getHeight() + 15;
            dimension.width += jScrollPane.getVerticalScrollBar().getWidth() + 15;
            WriteXMPAction.this.panel.setSize(dimension);
            this.progressArea.setBackground(Color.WHITE);
            this.progressArea.setEditable(false);
            this.progressArea.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.progressArea.setText("");
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
            jPanel.add(jScrollPane);
            ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
            buttonBarBuilder.addGlue();
            buttonBarBuilder.addButton((JComponent)this.okButton);
            buttonBarBuilder.addRelatedGap();
            buttonBarBuilder.addButton((JComponent)this.cancelButton);
            buttonBarBuilder.addGlue();
            JPanel jPanel2 = buttonBarBuilder.getPanel();
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
            this.getContentPane().add((Component)jPanel, "Center");
            this.getContentPane().add((Component)jPanel2, "South");
            this.pack();
            this.setResizable(false);
        }

        public void done() {
            this.okButton.setEnabled(true);
            this.cancelButton.setEnabled(false);
        }

        public void open() {
            this.progressArea.setText("");
            this.canceled = false;
            Util.placeDialog(WriteXMPAction.this.optDiag, WriteXMPAction.this.panel.frame());
            this.okButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
            new FocusRequester(this.okButton);
            WriteXMPAction.this.optDiag.setVisible(true);
        }
    }
}

