/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups.structure;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.GroupHierarchyType;
import net.sf.jabref.groups.structure.UnsupportedVersionException;
import net.sf.jabref.search.SearchRule;
import net.sf.jabref.search.SearchRules;
import net.sf.jabref.search.describer.SearchDescribers;
import net.sf.jabref.util.QuotedStringTokenizer;
import net.sf.jabref.util.StringUtil;

public class SearchGroup
extends AbstractGroup {
    public static final String ID = "SearchGroup:";
    private final String searchExpression;
    private final boolean caseSensitive;
    private final boolean regExp;
    private final SearchRule searchRule;

    public SearchGroup(String string, String string2, boolean bl, boolean bl2, GroupHierarchyType groupHierarchyType) {
        super(string, groupHierarchyType);
        this.searchExpression = string2;
        this.caseSensitive = bl;
        this.regExp = bl2;
        this.searchRule = SearchRules.getSearchRuleByQuery(string2, bl, bl2);
    }

    public static AbstractGroup fromString(String string, BibtexDatabase bibtexDatabase, int n) throws Exception {
        if (!string.startsWith(ID)) {
            throw new Exception("Internal error: SearchGroup cannot be created from \"" + string + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string.substring(ID.length()), ";", '\\');
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                String string2 = quotedStringTokenizer.nextToken();
                String string3 = quotedStringTokenizer.nextToken();
                boolean bl = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                boolean bl2 = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                return new SearchGroup(StringUtil.unquote(string2, '\\'), StringUtil.unquote(string3, '\\'), bl, bl2, GroupHierarchyType.INDEPENDENT);
            }
            case 3: {
                String string4 = quotedStringTokenizer.nextToken();
                int n2 = Integer.parseInt(quotedStringTokenizer.nextToken());
                String string5 = quotedStringTokenizer.nextToken();
                boolean bl = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                boolean bl3 = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                return new SearchGroup(StringUtil.unquote(string4, '\\'), StringUtil.unquote(string5, '\\'), bl, bl3, GroupHierarchyType.getByNumber(n2));
            }
        }
        throw new UnsupportedVersionException("SearchGroup", n);
    }

    @Override
    public String getTypeId() {
        return ID;
    }

    @Override
    public SearchRule getSearchRule() {
        return this.searchRule;
    }

    public String toString() {
        return ID + StringUtil.quote(this.name, ";", '\\') + ";" + this.context.ordinal() + ";" + StringUtil.quote(this.searchExpression, ";", '\\') + ";" + StringUtil.booleanToBinaryString(this.caseSensitive) + ";" + StringUtil.booleanToBinaryString(this.regExp) + ";";
    }

    public String getSearchExpression() {
        return this.searchExpression;
    }

    @Override
    public boolean supportsAdd() {
        return false;
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public AbstractUndoableEdit add(BibtexEntry[] bibtexEntryArray) {
        return null;
    }

    @Override
    public AbstractUndoableEdit remove(BibtexEntry[] bibtexEntryArray) {
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SearchGroup)) {
            return false;
        }
        SearchGroup searchGroup = (SearchGroup)object;
        return this.name.equals(searchGroup.name) && this.searchExpression.equals(searchGroup.searchExpression) && this.caseSensitive == searchGroup.caseSensitive && this.regExp == searchGroup.regExp && this.getHierarchicalContext() == searchGroup.getHierarchicalContext();
    }

    @Override
    public boolean contains(String string, BibtexEntry bibtexEntry) {
        return this.getSearchRule().applyRule(string, bibtexEntry);
    }

    @Override
    public boolean contains(BibtexEntry bibtexEntry) {
        return this.contains("dummy", bibtexEntry);
    }

    @Override
    public AbstractGroup deepCopy() {
        try {
            return new SearchGroup(this.name, this.searchExpression, this.caseSensitive, this.regExp, this.context);
        }
        catch (Throwable throwable) {
            System.err.println("Internal error: Exception " + throwable + " in SearchGroup.deepCopy(). " + "Please report this on www.sf.net/projects/jabref");
            return null;
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRegExp() {
        return this.regExp;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String getDescription() {
        return SearchDescribers.getSearchDescriberFor(this.searchRule, this.searchExpression).getDescription();
    }

    @Override
    public String getShortDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<b>");
        if (Globals.prefs.getBoolean("groupShowDynamic")) {
            stringBuilder.append("<i>").append(StringUtil.quoteForHTML(this.getName())).append("</i>");
        } else {
            stringBuilder.append(StringUtil.quoteForHTML(this.getName()));
        }
        stringBuilder.append("</b> - ");
        stringBuilder.append(Globals.lang("dynamic group"));
        stringBuilder.append(" (");
        stringBuilder.append(Globals.lang("search expression"));
        stringBuilder.append(" <b>").append(StringUtil.quoteForHTML(this.searchExpression)).append("</b>)");
        switch (this.getHierarchicalContext()) {
            case INCLUDING: {
                stringBuilder.append(", ").append(Globals.lang("includes subgroups"));
                break;
            }
            case REFINING: {
                stringBuilder.append(", ").append(Globals.lang("refines supergroup"));
                break;
            }
        }
        return stringBuilder.toString();
    }
}

