/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.sf.jabref.autocompleter.AutoCompleter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoCompleteListener
extends KeyAdapter
implements FocusListener {
    private static final Log LOGGER = LogFactory.getLog(AutoCompleteListener.class);
    private final AutoCompleter completer;
    private String toSetIn = null;
    private String lastBeginning = null;
    private int lastCaretPosition = -1;
    private String[] lastCompletions = null;
    private int lastShownCompletion = 0;
    private boolean consumeEnterKey = true;
    private FocusListener nextFocusListener = null;
    private static final int ANY_NAME = 0;
    private static final int FIRST_NAME = 1;
    static final int LAST_NAME = 2;

    public AutoCompleteListener(AutoCompleter autoCompleter) {
        this.completer = autoCompleter;
    }

    public void setNextFocusListener(FocusListener focusListener) {
        this.nextFocusListener = focusListener;
    }

    public void setConsumeEnterKey(boolean bl) {
        this.consumeEnterKey = bl;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.toSetIn != null && keyEvent.getKeyCode() == 10) {
            JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
            this.lastBeginning = this.lastCompletions[this.lastShownCompletion];
            int n = jTextComponent.getSelectionEnd();
            jTextComponent.select(n, n);
            this.toSetIn = null;
            if (this.consumeEnterKey) {
                keyEvent.consume();
            }
        } else if (keyEvent.getKeyCode() == 34 && this.toSetIn != null) {
            this.cycle((JTextComponent)keyEvent.getSource(), 1);
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 33 && this.toSetIn != null) {
            this.cycle((JTextComponent)keyEvent.getSource(), -1);
            keyEvent.consume();
        } else if (keyEvent.getKeyChar() == '\uffff') {
            if (keyEvent.getKeyCode() != 16) {
                this.resetAutoCompletion();
            } else {
                LOGGER.debug("Special case: shift pressed. No action.");
            }
        } else {
            LOGGER.debug("Special case: defined character, but not caught above");
        }
    }

    private void cycle(JTextComponent jTextComponent, int n) {
        assert (this.lastCompletions != null);
        assert (this.lastCompletions.length > 0);
        this.lastShownCompletion += n;
        if (this.lastShownCompletion >= this.lastCompletions.length) {
            this.lastShownCompletion = 0;
        } else if (this.lastShownCompletion < 0) {
            this.lastShownCompletion = this.lastCompletions.length - 1;
        }
        String string = this.lastCompletions[this.lastShownCompletion];
        this.toSetIn = string.substring(this.lastBeginning.length() - 1);
        StringBuilder stringBuilder = new StringBuilder(jTextComponent.getText());
        int n2 = jTextComponent.getSelectionStart();
        int n3 = jTextComponent.getSelectionEnd();
        int n4 = jTextComponent.getSelectionStart() - this.lastBeginning.length();
        stringBuilder.delete(n4, n2);
        stringBuilder.insert(n4, string.subSequence(0, this.lastBeginning.length()));
        stringBuilder.delete(n2, n3);
        stringBuilder.insert(n2, this.toSetIn.substring(1));
        jTextComponent.setText(stringBuilder.toString());
        jTextComponent.select(n2, n2 + this.toSetIn.length() - 1);
        this.lastCaretPosition = jTextComponent.getCaretPosition();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setUnmodifiedTypedLetters(JTextComponent jTextComponent, boolean bl, boolean bl2) {
        if (this.lastBeginning == null) {
            LOGGER.debug("No last beginning found");
            return;
        }
        LOGGER.debug("lastBeginning: >" + this.lastBeginning + '<');
        if (jTextComponent.getSelectedText() == null) {
            if (!bl2) return;
            LOGGER.debug("Replacing complete word");
        } else {
            LOGGER.debug("Selected text " + jTextComponent.getSelectedText() + " will be removed");
            jTextComponent.replaceSelection("");
        }
        this.lastCaretPosition = jTextComponent.getCaretPosition();
        int n = this.lastCaretPosition - this.lastBeginning.length();
        if (bl) {
            ++n;
        }
        String string = jTextComponent.getText();
        jTextComponent.setText(string.substring(0, n).concat(this.lastBeginning).concat(string.substring(this.lastCaretPosition)));
        if (bl) {
            ++this.lastCaretPosition;
        }
        jTextComponent.setCaretPosition(this.lastCaretPosition);
        this.lastBeginning = null;
    }

    private void startCompletion(StringBuffer stringBuffer, KeyEvent keyEvent) {
        JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
        String[] stringArray = this.findCompletions(stringBuffer.toString(), jTextComponent);
        String string = this.completer.getPrefix();
        String string2 = string != null && !string.isEmpty() ? stringBuffer.toString().substring(string.length()) : stringBuffer.toString();
        LOGGER.debug("StartCompletion currentword: >" + stringBuffer + "'<' prefix: >" + string + "'<' cword: >" + string2 + '<');
        int n = 0;
        if (stringArray != null && stringArray.length > 0) {
            this.lastShownCompletion = 0;
            this.lastCompletions = stringArray;
            String string3 = stringArray[n];
            this.toSetIn = string3.substring(string2.length() - 1);
            LOGGER.debug("toSetIn: >" + this.toSetIn + '<');
            StringBuilder stringBuilder = new StringBuilder(jTextComponent.getText());
            int n2 = jTextComponent.getCaretPosition();
            stringBuilder.insert(n2, this.toSetIn);
            jTextComponent.setText(stringBuilder.toString());
            jTextComponent.setCaretPosition(n2);
            jTextComponent.select(n2 + 1, n2 + 1 + string3.length() - string2.length());
            keyEvent.consume();
            this.lastCaretPosition = jTextComponent.getCaretPosition();
            char c = keyEvent.getKeyChar();
            LOGGER.debug("Appending >" + c + '<');
            this.lastBeginning = string2.length() <= 1 ? Character.toString(c) : string2.substring(0, string2.length() - 1).concat(Character.toString(c));
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        LOGGER.debug("key typed event caught " + keyEvent.getKeyCode());
        char c = keyEvent.getKeyChar();
        if (c == '\n') {
            return;
        }
        if ((keyEvent.getModifiers() | 1) == 1) {
            if (Character.isLetter(c) || Character.isDigit(c) || Character.isWhitespace(c) && this.completer.isSingleUnitField()) {
                JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
                if (this.toSetIn == null) {
                    LOGGER.debug("toSetIn is null");
                } else {
                    LOGGER.debug("toSetIn: >" + this.toSetIn + '<');
                }
                if (this.toSetIn != null && this.toSetIn.length() > 1 && c == this.toSetIn.charAt(1)) {
                    LOGGER.debug("cont");
                    this.toSetIn = this.toSetIn.substring(1);
                    if (!this.toSetIn.isEmpty()) {
                        int n = jTextComponent.getCaretPosition();
                        jTextComponent.select(n + 1 - this.toSetIn.length(), n);
                        this.lastBeginning = this.lastBeginning + c;
                        keyEvent.consume();
                        this.lastCaretPosition = jTextComponent.getCaretPosition();
                        this.lastCompletions = this.findCompletions(this.lastBeginning, jTextComponent);
                        this.lastShownCompletion = 0;
                        for (int i = 0; i < this.lastCompletions.length; ++i) {
                            String string = this.lastCompletions[i];
                            if (!string.endsWith(this.toSetIn)) continue;
                            this.lastShownCompletion = i;
                            break;
                        }
                        if (this.toSetIn.length() < 2) {
                            String string = jTextComponent.getText();
                            jTextComponent.setText(string.substring(0, this.lastCaretPosition - this.lastBeginning.length()) + this.lastBeginning + string.substring(this.lastCaretPosition));
                            this.toSetIn = null;
                        }
                        return;
                    }
                }
                if (this.toSetIn != null && (this.toSetIn.length() <= 1 || c != this.toSetIn.charAt(1))) {
                    this.lastBeginning = this.lastBeginning + c;
                    LOGGER.debug("discont toSetIn: >" + this.toSetIn + "'<' lastBeginning: >" + this.lastBeginning + '<');
                    String[] stringArray = this.findCompletions(this.lastBeginning, jTextComponent);
                    if (stringArray != null && stringArray.length > 0) {
                        this.lastShownCompletion = 0;
                        this.lastCompletions = stringArray;
                        String string = stringArray[0];
                        int n = this.toSetIn.length() - 1;
                        this.toSetIn = string.substring(this.lastBeginning.length() - 1);
                        String string2 = jTextComponent.getText();
                        jTextComponent.setText(string2.substring(0, this.lastCaretPosition - n - this.lastBeginning.length() + 1) + string + string2.substring(this.lastCaretPosition));
                        int n2 = this.lastCaretPosition + 1 - n;
                        int n3 = this.lastCaretPosition + this.toSetIn.length() - n;
                        jTextComponent.select(n2, n3);
                        this.lastCaretPosition = jTextComponent.getCaretPosition();
                        keyEvent.consume();
                        return;
                    }
                    this.setUnmodifiedTypedLetters(jTextComponent, true, false);
                    keyEvent.consume();
                    this.toSetIn = null;
                    return;
                }
                LOGGER.debug("case else");
                jTextComponent.replaceSelection("");
                StringBuffer stringBuffer = this.getCurrentWord(jTextComponent);
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                assert (!Character.isISOControl(c));
                stringBuffer.append(c);
                this.startCompletion(stringBuffer, keyEvent);
                return;
            }
            if (Character.isWhitespace(c)) {
                assert (!this.completer.isSingleUnitField());
                LOGGER.debug("whitespace && !singleUnitField");
                this.setUnmodifiedTypedLetters((JTextComponent)keyEvent.getSource(), false, true);
                this.resetAutoCompletion();
                return;
            }
            LOGGER.debug("No letter/digit/whitespace or CHAR_UNDEFINED");
            this.setUnmodifiedTypedLetters((JTextComponent)keyEvent.getSource(), false, !Character.isISOControl(c));
            this.resetAutoCompletion();
            return;
        }
        this.resetAutoCompletion();
    }

    private void resetAutoCompletion() {
        LOGGER.debug("Resetting autocompletion");
        this.toSetIn = null;
        this.lastBeginning = null;
    }

    private String[] findCompletions(String string, JTextComponent jTextComponent) {
        return this.completer.complete(string);
    }

    private StringBuffer getCurrentWord(JTextComponent jTextComponent) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = jTextComponent.getText(0, jTextComponent.getCaretPosition());
            if (!this.completer.isSingleUnitField()) {
                int n;
                if (jTextComponent.getCaretPosition() < jTextComponent.getText().length() && Character.isWhitespace(jTextComponent.getText().charAt(jTextComponent.getCaretPosition()))) {
                    return null;
                }
                for (n = string.length() - 1; n >= 0 && !Character.isWhitespace(string.charAt(n)); --n) {
                }
                stringBuffer.append(string.substring(n + 1));
            } else {
                stringBuffer.append(string);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return stringBuffer;
    }

    protected int findNamePositionStatus(JTextComponent jTextComponent) {
        try {
            String string = jTextComponent.getText(0, jTextComponent.getCaretPosition());
            string = string.substring(string.lastIndexOf(" and ") + 1);
            int n = string.indexOf(44);
            if (n < 0) {
                return 0;
            }
            return 1;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.nextFocusListener != null) {
            this.nextFocusListener.focusGained(focusEvent);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.toSetIn != null) {
            JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
            this.clearCurrentSuggestion(jTextComponent);
        }
        if (this.nextFocusListener != null) {
            this.nextFocusListener.focusLost(focusEvent);
        }
    }

    public void clearCurrentSuggestion(JTextComponent jTextComponent) {
        if (this.toSetIn != null) {
            int n = jTextComponent.getSelectionStart();
            String string = jTextComponent.getText();
            jTextComponent.setText(string.substring(0, n) + string.substring(jTextComponent.getSelectionEnd()));
            jTextComponent.setCaretPosition(n);
            this.lastCompletions = null;
            this.lastShownCompletion = 0;
            this.lastCaretPosition = -1;
            this.toSetIn = null;
        }
    }
}

