/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import net.sf.jabref.EntryContainer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.external.DroppedFileHandler;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.groups.EntryTableTransferHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class FileListEditorTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private DataFlavor urlFlavor;
    private final DataFlavor stringFlavor;
    private final JabRefFrame frame;
    private final EntryContainer entryContainer;
    private final TransferHandler textTransferHandler;
    private DroppedFileHandler dfh = null;
    private static final Log LOGGER = LogFactory.getLog(FileListEditorTransferHandler.class);

    public FileListEditorTransferHandler(JabRefFrame jabRefFrame, EntryContainer entryContainer, TransferHandler transferHandler) {
        this.frame = jabRefFrame;
        this.entryContainer = entryContainer;
        this.textTransferHandler = transferHandler;
        this.stringFlavor = DataFlavor.stringFlavor;
        try {
            this.urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.info("Unable to configure drag and drop for file link table", classNotFoundException);
        }
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 0x40000001;
    }

    @Override
    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
        if (this.textTransferHandler != null) {
            this.textTransferHandler.exportToClipboard(jComponent, clipboard, n);
        }
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        Object object;
        try {
            object = null;
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                object = (DataFlavor[])transferable.getTransferData(DataFlavor.javaFileListFlavor);
            }
            if (transferable.isDataFlavorSupported(this.urlFlavor)) {
                URL object2 = (URL)transferable.getTransferData(this.urlFlavor);
                System.out.println("URL: " + object2);
            }
            if (transferable.isDataFlavorSupported(this.stringFlavor)) {
                String string = (String)transferable.getTransferData(this.stringFlavor);
                object = EntryTableTransferHandler.getFilesFromDraggedFilesString(string);
            }
            if (object != null) {
                DataFlavor[] dataFlavorArray = object;
                SwingUtilities.invokeLater(new Runnable((List)dataFlavorArray){
                    final /* synthetic */ List val$theFiles;
                    {
                        this.val$theFiles = list;
                    }

                    @Override
                    public void run() {
                        for (File file : this.val$theFiles) {
                            String string = file.getAbsolutePath();
                            ExternalFileType externalFileType = null;
                            int n = string.lastIndexOf(46);
                            if (n >= 0 && n < string.length()) {
                                String string2 = string.substring(n + 1).toLowerCase();
                                externalFileType = Globals.prefs.getExternalFileTypeByExt(string2);
                            }
                            if (externalFileType == null) continue;
                            if (FileListEditorTransferHandler.this.dfh == null) {
                                FileListEditorTransferHandler.this.dfh = new DroppedFileHandler(FileListEditorTransferHandler.this.frame, FileListEditorTransferHandler.this.frame.basePanel());
                            }
                            FileListEditorTransferHandler.this.dfh.handleDroppedfile(string, externalFileType, true, FileListEditorTransferHandler.this.entryContainer.getEntry());
                        }
                    }
                });
                return true;
            }
        }
        catch (IOException iOException) {
            System.err.println("failed to read dropped data: " + iOException.toString());
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            System.err.println("drop type error: " + unsupportedFlavorException.toString());
        }
        System.err.println("can't transfer input: ");
        for (DataFlavor dataFlavor : object = transferable.getTransferDataFlavors()) {
            System.out.println("  " + dataFlavor.toString());
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!dataFlavor.match(this.urlFlavor) && !dataFlavor.match(this.stringFlavor) && !dataFlavor.match(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }
}

