/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.sf.jabref.EntryEditorTabList;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.gui.GenFieldsCustomizer_cancel_actionAdapter;
import net.sf.jabref.gui.GenFieldsCustomizer_ok_actionAdapter;
import net.sf.jabref.gui.GenFieldsCustomizer_revert_actionAdapter;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.util.Util;

public class GenFieldsCustomizer
extends JDialog {
    private final JPanel buttons = new JPanel();
    private final JButton ok = new JButton();
    private final JButton cancel = new JButton();
    private JButton helpBut = new JButton();
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    private final JLabel jLabel1 = new JLabel();
    private final JPanel jPanel3 = new JPanel();
    private final JPanel jPanel4 = new JPanel();
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final JLabel jLabel2 = new JLabel();
    private final JTextArea fieldsArea = new JTextArea();
    private final GridBagLayout gridBagLayout2 = new GridBagLayout();
    private final JabRefFrame parent;
    private final JButton revert = new JButton();

    public GenFieldsCustomizer(JabRefFrame jabRefFrame) {
        super(jabRefFrame, Globals.lang("Set general fields"), false);
        this.parent = jabRefFrame;
        HelpAction helpAction = new HelpAction(this.parent.helpDiag, "GeneralFields.html", "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.helpBut = new JButton(Globals.lang("Help"));
        this.helpBut.addActionListener(helpAction);
        try {
            this.jbInit();
            this.setSize(new Dimension(650, 300));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() {
        this.ok.setText(Globals.lang("Ok"));
        this.ok.addActionListener(new GenFieldsCustomizer_ok_actionAdapter(this));
        this.cancel.setText(Globals.lang("Cancel"));
        this.cancel.addActionListener(new GenFieldsCustomizer_cancel_actionAdapter(this));
        this.jLabel1.setText(Globals.lang("Delimit fields with semicolon, ex.") + ": url;pdf;note");
        this.jPanel3.setLayout(this.gridBagLayout2);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel4.setLayout(this.gridBagLayout1);
        this.jLabel2.setText(Globals.lang("General fields"));
        this.setFieldsText();
        this.revert.setText(Globals.lang("Default"));
        this.revert.addActionListener(new GenFieldsCustomizer_revert_actionAdapter(this));
        this.getContentPane().add((Component)this.buttons, "South");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)this.revert);
        buttonBarBuilder.addButton((JComponent)this.cancel);
        buttonBarBuilder.addStrut(Sizes.DLUX5);
        buttonBarBuilder.addButton((JComponent)this.helpBut);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel3.add((Component)this.jPanel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 318, 193));
        this.jPanel4.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.fieldsArea, null);
        this.jPanel4.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        ActionMap actionMap = this.buttons.getActionMap();
        InputMap inputMap = this.buttons.getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenFieldsCustomizer.this.dispose();
            }
        });
    }

    void ok_actionPerformed(ActionEvent actionEvent) {
        int n;
        String[] stringArray = this.fieldsArea.getText().split("\n");
        for (n = 0; n < stringArray.length; ++n) {
            String string;
            String[] stringArray2 = stringArray[n].split(":");
            if (stringArray2.length != 2) {
                string = Globals.lang("field");
                JOptionPane.showMessageDialog(this, Globals.lang("Each line must be on the following form") + " '" + Globals.lang("Tabname") + ':' + string + "1;" + string + "2;...;" + string + "N'", Globals.lang("Error"), 0);
                return;
            }
            string = Util.checkLegalKey(stringArray2[1]);
            if (!string.equals(stringArray2[1]) || stringArray2[1].indexOf(38) >= 0) {
                JOptionPane.showMessageDialog(this, Globals.lang("Field names are not allowed to contain white space or the following characters") + ": # { } ~ , ^ &", Globals.lang("Error"), 0);
                return;
            }
            Globals.prefs.put("customTabName_" + n, stringArray2[0]);
            Globals.prefs.put("customTabFields_" + n, stringArray2[1].toLowerCase());
        }
        Globals.prefs.purgeSeries("customTabName_", n);
        Globals.prefs.purgeSeries("customTabFields_", n);
        Globals.prefs.updateEntryEditorTabList();
        this.parent.removeCachedEntryEditors();
        this.dispose();
    }

    void cancel_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void setFieldsText() {
        StringBuffer stringBuffer = new StringBuffer();
        EntryEditorTabList entryEditorTabList = Globals.prefs.getEntryEditorTabList();
        for (int i = 0; i < entryEditorTabList.getTabCount(); ++i) {
            stringBuffer.append(entryEditorTabList.getTabName(i));
            stringBuffer.append(':');
            Iterator<String> iterator = entryEditorTabList.getTabFields(i).iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                stringBuffer.append(string);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(';');
            }
            stringBuffer.append('\n');
        }
        this.fieldsArea.setText(stringBuffer.toString());
    }

    void revert_actionPerformed(ActionEvent actionEvent) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((string = (String)Globals.prefs.defaults.get("customTabName__def" + n)) != null) {
            stringBuffer.append(string);
            String string2 = (String)Globals.prefs.defaults.get("customTabFields__def" + n);
            stringBuffer.append(':');
            stringBuffer.append(string2);
            stringBuffer.append('\n');
            ++n;
        }
        this.fieldsArea.setText(stringBuffer.toString());
    }
}

