/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

class HtmlTransferable
implements Transferable {
    private static final int HTML = 0;
    private static final int STRING = 1;
    private static final DataFlavor HTML_FLAVOR = new DataFlavor("text/html;charset=utf-8;class=java.lang.String", "HTML Format");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{HTML_FLAVOR, DataFlavor.stringFlavor};
    private final String htmlText;
    private final String plainText;

    public HtmlTransferable(String string, String string2) {
        this.htmlText = string;
        this.plainText = string2;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (DataFlavor dataFlavor2 : FLAVORS) {
            if (!dataFlavor.equals(dataFlavor2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(FLAVORS[1])) {
            return this.plainText;
        }
        if (dataFlavor.equals(FLAVORS[0])) {
            return this.htmlText;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

