/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.MainTable;

public class PersistenceTableColumnListener
implements TableColumnModelListener {
    public static final String ACTIVATE_PREF_KEY = "ActivatePersistenceTableColumnListener";
    public static final boolean DEFAULT_ENABLED = true;
    private static final String simpleClassName = PersistenceTableColumnListener.class.getSimpleName();
    private final MainTable mainTable;

    public PersistenceTableColumnListener(MainTable mainTable) {
        this.mainTable = mainTable;
    }

    private void updateColumnPrefs() {
        int n = this.mainTable.getColumnCount();
        Vector<String> vector = new Vector<String>(n - 1);
        Vector<String> vector2 = new Vector<String>(n - 1);
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            String string = this.mainTable.getColumnName(i);
            if (string == null || string.isEmpty()) continue;
            if (string.equals("#")) {
                n2 = this.mainTable.getColumnModel().getColumn(i).getWidth();
                continue;
            }
            vector.add(string.toLowerCase());
            vector2.add(String.valueOf(this.mainTable.getColumnModel().getColumn(i).getWidth()));
        }
        Globals.prefs.putStringArray("columnNames", vector.toArray(new String[vector.size()]));
        Globals.prefs.putStringArray("columnWidths", vector2.toArray(new String[vector2.size()]));
        Globals.prefs.putInt("numberColWidth", n2);
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        assert (tableColumnModelEvent != null) : simpleClassName + " received null event";
        this.updateColumnPrefs();
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        assert (changeEvent != null) : simpleClassName + " received null event";
        this.updateColumnPrefs();
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        assert (tableColumnModelEvent != null) : simpleClassName + " received null event";
        if (tableColumnModelEvent.getFromIndex() == tableColumnModelEvent.getToIndex()) {
            return;
        }
        this.updateColumnPrefs();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        assert (tableColumnModelEvent != null) : simpleClassName + " received null event";
        this.updateColumnPrefs();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }
}

