/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JPanel;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;

public class ADSFetcher
implements EntryFetcher {
    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getHelpPage() {
        return null;
    }

    @Override
    public String getKeyName() {
        return "ADS from ADS-DOI";
    }

    @Override
    public String getTitle() {
        return Globals.menuTitle(this.getKeyName());
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        try {
            String string2 = string = string.replaceAll("^(doi:|DOI:)", "");
            outputPrinter.setStatus(Globals.lang("Processing ") + string2);
            BibtexDatabase bibtexDatabase = this.importADSEntries(string2, outputPrinter);
            outputPrinter.setStatus("Adding fetched entries");
            if (bibtexDatabase.getEntryCount() > 0) {
                for (BibtexEntry bibtexEntry : bibtexDatabase.getEntries()) {
                    this.importADSAbstract(string2, bibtexEntry, outputPrinter);
                    importInspector.addEntry(bibtexEntry);
                }
            }
        }
        catch (Exception exception) {
            outputPrinter.setStatus(Globals.lang("Error while fetching from ADS") + ": " + exception.getMessage());
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public void stopFetching() {
    }

    private BibtexDatabase importADSEntries(String string, OutputPrinter outputPrinter) {
        String string2 = this.constructUrl(string);
        try {
            URL uRL = new URL(string2 + "&data_type=BIBTEX");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", "Jabref");
            InputStream inputStream = httpURLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            ParserResult parserResult = BibtexParser.parse(bufferedReader);
            return parserResult.getDatabase();
        }
        catch (IOException iOException) {
            outputPrinter.showMessage(Globals.lang("An Exception ocurred while accessing '%0'", string2) + "\n\n" + iOException.toString(), Globals.lang(this.getKeyName()), 0);
        }
        catch (RuntimeException runtimeException) {
            outputPrinter.showMessage(Globals.lang("An Error occurred while fetching from ADS (%0):", new String[]{string2}) + "\n\n" + runtimeException.getMessage(), Globals.lang(this.getKeyName()), 0);
        }
        return null;
    }

    private String constructUrl(String string) {
        return "http://adsabs.harvard.edu/doi/" + string;
    }

    private void importADSAbstract(String string, BibtexEntry bibtexEntry, OutputPrinter outputPrinter) {
        String string2 = this.constructUrl(string);
        try {
            URL uRL = new URL(string2 + "&data_type=XML");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", "Jabref");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(bufferedInputStream);
            boolean bl = false;
            String string3 = "";
            while (xMLStreamReader.hasNext()) {
                xMLStreamReader.next();
                if (xMLStreamReader.isStartElement() && xMLStreamReader.getLocalName().equals("abstract")) {
                    bl = true;
                }
                if (bl && xMLStreamReader.isCharacters()) {
                    string3 = string3 + xMLStreamReader.getText();
                }
                if (!bl || !xMLStreamReader.isEndElement()) continue;
                bl = false;
            }
            string3 = string3.replace("\n", " ");
            bibtexEntry.setField("abstract", string3);
        }
        catch (XMLStreamException xMLStreamException) {
            outputPrinter.showMessage(Globals.lang("An Error occurred while parsing abstract"), Globals.lang(this.getKeyName()), 0);
        }
        catch (IOException iOException) {
            outputPrinter.showMessage(Globals.lang("An Exception ocurred while accessing '%0'", string2) + "\n\n" + iOException.toString(), Globals.lang(this.getKeyName()), 0);
        }
        catch (RuntimeException runtimeException) {
            outputPrinter.showMessage(Globals.lang("An Error occurred while fetching from ADS (%0):", new String[]{string2}) + "\n\n" + runtimeException.getMessage(), Globals.lang(this.getKeyName()), 0);
        }
    }
}

