/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibTeXMLHandler;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BibteXMLImporter
extends ImportFormat {
    private static final Log LOGGER = LogFactory.getLog(BibteXMLImporter.class);

    @Override
    public String getFormatName() {
        return "BibTeXML";
    }

    @Override
    public String getCLIId() {
        return "bibtexml";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("<bibtex:file .*");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            BibTeXMLHandler bibTeXMLHandler = new BibTeXMLHandler();
            sAXParser.parse(inputStream, (DefaultHandler)bibTeXMLHandler);
            arrayList = bibTeXMLHandler.getItems();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Error with XML parser configuration", parserConfigurationException);
            outputPrinter.showMessage(parserConfigurationException.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            LOGGER.error("Error during XML parsing", sAXException);
            outputPrinter.showMessage(sAXException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            LOGGER.error("Error during file import", iOException);
            outputPrinter.showMessage(iOException.getLocalizedMessage());
        }
        return arrayList;
    }
}

