/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.util.NameListNormalizer;

public class CiteSeerXFetcher
implements EntryFetcher {
    private static final int MAX_PAGES_TO_LOAD = 8;
    private static final String QUERY_MARKER = "___QUERY___";
    private static final String URL_START = "http://citeseer.ist.psu.edu";
    private static final String SEARCH_URL = "http://citeseer.ist.psu.edu/search?q=___QUERY___&submit=Search&sort=rlv&t=doc";
    private static final Pattern CITE_LINK_PATTERN = Pattern.compile("<a class=\"remove doc_details\" href=\"(.*)\">");
    private boolean stopFetching = false;
    private static final String basePattern = "<meta name=\"___QUERY___\" content=\"(.*)\" />";
    private static final Pattern titlePattern = Pattern.compile("<meta name=\"___QUERY___\" content=\"(.*)\" />".replace("___QUERY___", "citation_title"));
    private static final Pattern authorPattern = Pattern.compile("<meta name=\"___QUERY___\" content=\"(.*)\" />".replace("___QUERY___", "citation_authors"));
    private static final Pattern yearPattern = Pattern.compile("<meta name=\"___QUERY___\" content=\"(.*)\" />".replace("___QUERY___", "citation_year"));
    private static final Pattern abstractPattern = Pattern.compile("<h3>Abstract</h3>\\s*<p>(.*)</p>");

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        this.stopFetching = false;
        try {
            List<String> list = this.getCitations(string);
            for (String string2 : list) {
                if (this.stopFetching) break;
                BibtexEntry bibtexEntry = this.getSingleCitation(string2);
                if (bibtexEntry == null) continue;
                importInspector.addEntry(bibtexEntry);
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    @Override
    public String getTitle() {
        return "CiteSeerX";
    }

    @Override
    public String getKeyName() {
        return "CiteSeerX";
    }

    @Override
    public String getHelpPage() {
        return "CiteSeerHelp.html";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
    }

    private List<String> getCitations(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            String string3 = SEARCH_URL.replace(QUERY_MARKER, URLEncoder.encode(string, "UTF-8"));
            for (int i = 1; (string2 = this.getCitationsFromUrl(string3, arrayList)) != null && i < 8; ++i) {
                string3 = string2;
                if (!this.stopFetching) continue;
            }
            return arrayList;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private String getCitationsFromUrl(String string, List<String> list) throws IOException {
        URL uRL = new URL(string);
        String string2 = new URLDownload(uRL).downloadToString();
        Matcher matcher = CITE_LINK_PATTERN.matcher(string2);
        while (matcher.find()) {
            list.add(URL_START + matcher.group(1));
        }
        return null;
    }

    private BibtexEntry getSingleCitation(String string) throws IOException {
        URL uRL = new URL(string);
        String string2 = new URLDownload(uRL).downloadToString("UTF8");
        Matcher matcher = titlePattern.matcher(string2);
        if (matcher.find()) {
            BibtexEntry bibtexEntry = new BibtexEntry(IdGenerator.next());
            bibtexEntry.setField("title", matcher.group(1));
            matcher = authorPattern.matcher(string2);
            if (matcher.find()) {
                String string3 = matcher.group(1);
                bibtexEntry.setField("author", NameListNormalizer.normalizeAuthorList(string3));
            }
            if ((matcher = yearPattern.matcher(string2)).find()) {
                bibtexEntry.setField("year", matcher.group(1));
            }
            if ((matcher = abstractPattern.matcher(string2)).find()) {
                bibtexEntry.setField("abstract", matcher.group(1));
            }
            return bibtexEntry;
        }
        return null;
    }
}

