/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class CsaImporter
extends ImportFormat {
    private int line;
    private static final Pattern FIELD_PATTERN = Pattern.compile("^([A-Z][A-Z]): ([A-Z].*)$");
    private static final Pattern VOLNOPP_PATTERN = Pattern.compile("[;,\\.]\\s+(\\d+[A-Za-z]?)\\((\\d+(?:-\\d+)?)\\)(?:,\\s+|:)(\\d+-\\d+)");
    private static final Pattern PAGES_PATTERN = Pattern.compile("[;,\\.]\\s+(?:(\\[?[vn]\\.?p\\.?\\]?)|(?:pp?\\.?\\s+)(\\d+[A-Z]?(?:-\\d+[A-Z]?)?)|(\\d+[A-Z]?(?:-\\d+[A-Z]?)?)(?:\\s+pp?))");
    private static final Pattern VOLUME_PATTERN = Pattern.compile("[;,\\.]?\\s+[vV][oO][lL]\\.?\\s+(\\d+[A-Z]?(?:-\\d+[A-Z]?)?)");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[;,\\.]\\s+(?:No|no|Part|part|NUMB)\\.?\\s+([A-Z]?\\d+(?:[/-]\\d+)?)");
    private static final Pattern DATE_PATTERN = Pattern.compile("[;,\\.]\\s+(?:(\\d+)\\s)?(?:([A-Z][a-z][a-z])[\\.,]*\\s)?\\(?(\\d\\d\\d\\d)\\)?(?:\\s([A-Z][a-z][a-z]))?(?:\\s+(\\d+))?");
    private static final Pattern LT_PATTERN = Pattern.compile("\\[Lt\\]");
    private static final String MONS = "jan feb mar apr may jun jul aug sep oct nov dec";
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    @Override
    public String getFormatName() {
        return "CSA";
    }

    @Override
    public String getCLIId() {
        return "csa";
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string != null) {
            ++this.line;
        }
        return string;
    }

    private void addNote(HashMap<String, String> hashMap, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (hashMap.get("note") != null) {
            stringBuilder.append(hashMap.get("note"));
            stringBuilder.append("\n");
        }
        stringBuilder.append(string);
        hashMap.put("note", stringBuilder.toString());
    }

    private String parseDate(HashMap<String, String> hashMap, String string) {
        String string2;
        int n = -1;
        Matcher matcher = DATE_PATTERN.matcher(string);
        while (matcher.find()) {
            n = matcher.start();
        }
        if (n == -1) {
            return string;
        }
        if (!matcher.find(n)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = matcher.group(1);
        if (string3 == null) {
            string3 = matcher.group(5);
        } else if (matcher.group(5) != null) {
            return string;
        }
        if (string3 != null && !string3.equals("0")) {
            stringBuilder.append(string3);
            stringBuilder.append(" ");
        } else {
            string3 = null;
        }
        String string4 = matcher.group(2);
        if (string4 == null) {
            string4 = matcher.group(4);
        } else if (matcher.group(4) != null) {
            return string;
        }
        if (string4 != null) {
            string2 = string4.toLowerCase();
            int n2 = MONS.indexOf(string2);
            if (n2 == -1) {
                return string;
            }
            stringBuilder.append(string4);
            stringBuilder.append(" ");
            hashMap.put("month", MONTHS[n2 /= 4]);
        } else if (string3 != null) {
            return string;
        }
        string2 = matcher.group(3);
        stringBuilder.append(string2);
        StringBuilder stringBuilder2 = new StringBuilder();
        if (string3 != null && !string3.equals("0")) {
            stringBuilder2.append("Source Date: ");
            stringBuilder2.append((CharSequence)stringBuilder);
            stringBuilder2.append(".");
            this.addNote(hashMap, stringBuilder2.toString());
        }
        if (hashMap.get("year") != null) {
            String string5 = hashMap.get("year");
            if (!string2.equals(string5)) {
                stringBuilder2.setLength(0);
                stringBuilder2.append("Source Year: ");
                stringBuilder2.append(string2);
                stringBuilder2.append(".");
                this.addNote(hashMap, stringBuilder2.toString());
            }
        } else {
            hashMap.put("year", string2);
        }
        int n3 = string.length();
        StringBuilder stringBuilder3 = new StringBuilder();
        if (matcher.start() > 0) {
            stringBuilder3.append(string.substring(0, matcher.start()));
        }
        if (matcher.end() < n3) {
            stringBuilder3.append(string.substring(matcher.end(), n3));
        }
        return stringBuilder3.toString();
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.equals("DN: Database Name")) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        String string = null;
        boolean bl = true;
        this.line = 1;
        String string2 = this.readLine(bufferedReader);
        while (true) {
            if (string2 == null || string2.length() == 0) {
                if (!hashMap.isEmpty()) {
                    Object object;
                    if (string == null) {
                        this.addNote(hashMap, "Publication Type: [NOT SPECIFIED]");
                        this.addNote(hashMap, "[PERHAPS NOT FULL FORMAT]");
                        string = "article";
                    }
                    if (string.equals("article") && hashMap.get("booktitle") != null) {
                        object = hashMap.get("booktitle");
                        hashMap.remove("booktitle");
                        hashMap.put("journal", (String)object);
                    }
                    object = new BibtexEntry("__ID", Globals.getEntryType(string));
                    ((BibtexEntry)object).setField(hashMap);
                    arrayList.add((BibtexEntry)object);
                }
                hashMap.clear();
                bl = true;
                if (string2 == null) break;
                string2 = this.readLine(bufferedReader);
                continue;
            }
            int n = this.line;
            Matcher matcher = FIELD_PATTERN.matcher(string2);
            if (matcher.find()) {
                Object object;
                Object object2;
                String string3;
                String string4 = matcher.group(1);
                String string5 = matcher.group(2);
                stringBuilder.setLength(0);
                while ((string2 = this.readLine(bufferedReader)) != null && string2.startsWith("    ")) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(string2.substring(4));
                }
                String string6 = stringBuilder.toString();
                if (string6.length() == 0) {
                    int n2 = this.line - 1;
                    throw new IOException("illegal empty field at line " + n2);
                }
                matcher = LT_PATTERN.matcher(string6);
                if (matcher.find()) {
                    string6 = matcher.replaceAll("<");
                }
                if (string4.equals("DN") && string5.equalsIgnoreCase("Database Name")) {
                    if (!bl) {
                        throw new IOException("format error at line " + n + ": DN out of order");
                    }
                    bl = false;
                } else if (bl) {
                    throw new IOException("format error at line " + n + ": missing DN");
                }
                if (string4.equals("PT")) {
                    string = null;
                    string3 = string6.toLowerCase();
                    for (String string7 : object2 = string3.split("; ")) {
                        if (string7.contains("article") || string7.contains("journal article")) {
                            string = "article";
                            break;
                        }
                        if (string7.equals("dissertation")) {
                            string = "phdthesis";
                            break;
                        }
                        if (string7.equals("conference")) {
                            string = "inproceedings";
                            break;
                        }
                        if (string7.equals("book monograph") && string == null) {
                            string = "book";
                            break;
                        }
                        if (!string7.equals("report") || string != null) continue;
                        string = "techreport";
                        break;
                    }
                    if (string == null) {
                        string = "misc";
                    }
                }
                string3 = null;
                if (string4.equals("AB")) {
                    string3 = "abstract";
                } else if (string4.equals("AF")) {
                    string3 = "affiliation";
                } else if (string4.equals("AU")) {
                    string3 = "author";
                    if (string6.contains(";")) {
                        string6 = string6.replaceAll("; ", " and ");
                    }
                } else if (string4.equals("CA")) {
                    string3 = "organization";
                } else if (string4.equals("DE")) {
                    string3 = "keywords";
                } else if (string4.equals("DO")) {
                    string3 = "doi";
                } else if (string4.equals("ED")) {
                    string3 = "editor";
                } else if (string4.equals("IB")) {
                    string3 = "ISBN";
                } else if (string4.equals("IS")) {
                    string3 = "ISSN";
                } else if (string4.equals("JN")) {
                    string3 = "journal";
                } else if (string4.equals("LA")) {
                    string3 = "language";
                } else if (string4.equals("PB")) {
                    string3 = "publisher";
                } else if (string4.equals("PY")) {
                    string3 = "year";
                    if (hashMap.get("year") != null && !string6.equals(object2 = hashMap.get("year"))) {
                        this.addNote(hashMap, "Source Year: " + (String)object2 + ".");
                    }
                } else if (string4.equals("RL")) {
                    string3 = "url";
                    object2 = string6.split(" ");
                    object = new StringBuilder();
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        if (((String)object2[i]).startsWith("[URL:")) {
                            ((StringBuilder)object).append(((String)object2[i]).substring(5));
                            continue;
                        }
                        if (((String)object2[i]).endsWith("]")) {
                            int n3 = ((String)object2[i]).length();
                            ((StringBuilder)object).append(((String)object2[i]).substring(0, n3 - 1));
                            if (i >= ((Object)object2).length - 1) continue;
                            ((StringBuilder)object).append("\n");
                            continue;
                        }
                        ((StringBuilder)object).append((String)object2[i]);
                    }
                    string6 = ((StringBuilder)object).toString();
                } else if (string4.equals("SO")) {
                    string3 = "booktitle";
                    object2 = VOLNOPP_PATTERN.matcher(string6);
                    if (((Matcher)object2).find()) {
                        hashMap.put("volume", ((Matcher)object2).group(1));
                        hashMap.put("number", ((Matcher)object2).group(2));
                        hashMap.put("pages", ((Matcher)object2).group(3));
                        string6 = ((Matcher)object2).replaceFirst("");
                    }
                    object2 = PAGES_PATTERN.matcher(string6);
                    object = new StringBuilder();
                    while (((Matcher)object2).find()) {
                        String string8;
                        if (((StringBuilder)object).length() > 0) {
                            ((StringBuilder)object).append(",");
                        }
                        if ((string8 = ((Matcher)object2).group(1)) == null) {
                            string8 = ((Matcher)object2).group(2);
                        }
                        if (string8 == null) {
                            string8 = ((Matcher)object2).group(3);
                        }
                        ((StringBuilder)object).append(string8);
                        string6 = ((Matcher)object2).replaceFirst("");
                        object2 = PAGES_PATTERN.matcher(string6);
                    }
                    if (((StringBuilder)object).length() > 0) {
                        hashMap.put("pages", ((StringBuilder)object).toString());
                    }
                    if (((Matcher)(object2 = VOLUME_PATTERN.matcher(string6))).find()) {
                        hashMap.put("volume", ((Matcher)object2).group(1));
                        string6 = ((Matcher)object2).replaceFirst("");
                    }
                    if (((Matcher)(object2 = NUMBER_PATTERN.matcher(string6))).find()) {
                        hashMap.put("number", ((Matcher)object2).group(1));
                        string6 = ((Matcher)object2).replaceFirst("");
                    }
                    string6 = this.parseDate(hashMap, string6);
                    Pattern pattern = Pattern.compile(",?\\s*$");
                    object2 = pattern.matcher(string6);
                    if (((Matcher)object2).find()) {
                        string6 = ((Matcher)object2).replaceFirst("");
                    }
                    if (string6.equals("")) {
                        continue;
                    }
                } else if (string4.equals("TI")) {
                    string3 = "title";
                } else if (string4.equals("RE")) continue;
                if (string3 != null) {
                    hashMap.put(string3, string6);
                    continue;
                }
                this.addNote(hashMap, string5 + ": " + string6 + ".");
                continue;
            }
            string2 = this.readLine(bufferedReader);
        }
        return arrayList;
    }
}

