/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.JabRef;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.util.FileUtil;

class DatabaseFileLookup {
    private static final String KEY_FILE_FIELD = "file";
    private final HashMap<File, Boolean> fileToFound = new HashMap();
    private final Collection<BibtexEntry> entries;
    private final String[] possibleFilePaths;

    public DatabaseFileLookup(BibtexDatabase bibtexDatabase) {
        if (bibtexDatabase == null) {
            throw new IllegalArgumentException("Passing a 'null' BibtexDatabase.");
        }
        this.entries = bibtexDatabase.getEntries();
        this.possibleFilePaths = JabRef.jrf.basePanel().metaData().getFileDirectory(KEY_FILE_FIELD);
    }

    public boolean lookupDatabase(File file) {
        if (this.fileToFound.containsKey(file)) {
            return this.fileToFound.get(file);
        }
        Boolean bl = false;
        for (BibtexEntry bibtexEntry : this.entries) {
            if (!this.lookupEntry(file, bibtexEntry)) continue;
            bl = true;
            break;
        }
        this.fileToFound.put(file, bl);
        return bl;
    }

    private boolean lookupEntry(File file, BibtexEntry bibtexEntry) {
        FileListEntry fileListEntry;
        String string;
        if (file == null || bibtexEntry == null) {
            return false;
        }
        FileListTableModel fileListTableModel = new FileListTableModel();
        String string2 = bibtexEntry.getField(KEY_FILE_FIELD);
        fileListTableModel.setContent(string2);
        for (int i = 0; i < fileListTableModel.getRowCount() && (string = (fileListEntry = fileListTableModel.getEntry(i)).getLink()) != null; ++i) {
            File file2 = FileUtil.expandFilename(string, this.possibleFilePaths);
            if (file2 == null || !file2.equals(file)) continue;
            return true;
        }
        return false;
    }
}

