/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.gui.FetcherPreviewDialog;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.PreviewEntryFetcher;
import net.sf.jabref.util.Util;

public class GeneralFetcher
extends SidePaneComponent
implements ActionListener {
    private final JTextField tf = new JTextField();
    private final JButton helpBut = new JButton(GUIGlobals.getImage("helpSmall"));
    private final JComboBox fetcherChoice;
    private final CardLayout optionsCards = new CardLayout();
    private final JPanel optionsPanel = new JPanel(this.optionsCards);
    private final JPanel optPanel = new JPanel(new BorderLayout());
    private HelpAction help;
    private final SidePaneManager sidePaneManager;
    private final Action action;
    private final JabRefFrame frame;
    private EntryFetcher activeFetcher;
    private final EntryFetcher[] fetcherArray;

    public GeneralFetcher(SidePaneManager sidePaneManager, JabRefFrame jabRefFrame, List<EntryFetcher> list) {
        super(sidePaneManager, GUIGlobals.getIconUrl("www"), Globals.lang("Web search"));
        int n;
        this.sidePaneManager = sidePaneManager;
        this.frame = jabRefFrame;
        this.fetcherArray = list.toArray(new EntryFetcher[list.size()]);
        Arrays.sort(this.fetcherArray, new EntryFetcherComparator());
        String[] stringArray = new String[this.fetcherArray.length];
        for (n = 0; n < this.fetcherArray.length; ++n) {
            stringArray[n] = this.fetcherArray[n].getTitle();
        }
        this.fetcherChoice = new JComboBox<String>(stringArray);
        n = Globals.prefs.getInt("selectedFetcherIndex");
        if (n >= this.fetcherArray.length) {
            n = 0;
        }
        this.activeFetcher = this.fetcherArray[n];
        this.fetcherChoice.setSelectedIndex(n);
        if (this.activeFetcher.getOptionsPanel() != null) {
            this.optPanel.add((Component)this.activeFetcher.getOptionsPanel(), "Center");
        }
        this.helpBut.setEnabled(this.activeFetcher.getHelpPage() != null);
        this.fetcherChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralFetcher.this.activeFetcher = GeneralFetcher.this.fetcherArray[GeneralFetcher.this.fetcherChoice.getSelectedIndex()];
                Globals.prefs.putInt("selectedFetcherIndex", GeneralFetcher.this.fetcherChoice.getSelectedIndex());
                if (GeneralFetcher.this.activeFetcher.getHelpPage() != null) {
                    GeneralFetcher.this.help.setHelpFile(GeneralFetcher.this.activeFetcher.getHelpPage());
                    GeneralFetcher.this.helpBut.setEnabled(true);
                } else {
                    GeneralFetcher.this.helpBut.setEnabled(false);
                }
                GeneralFetcher.this.optionsCards.show(GeneralFetcher.this.optionsPanel, String.valueOf(GeneralFetcher.this.fetcherChoice.getSelectedIndex()));
                GeneralFetcher.this.optPanel.removeAll();
                if (GeneralFetcher.this.activeFetcher.getOptionsPanel() != null) {
                    GeneralFetcher.this.optPanel.add((Component)GeneralFetcher.this.activeFetcher.getOptionsPanel(), "Center");
                }
                GeneralFetcher.this.revalidate();
            }
        });
        this.action = new FetcherAction();
        this.help = new HelpAction(Globals.helpDiag, this.activeFetcher.getHelpPage(), "Help");
        this.helpBut.addActionListener(this.help);
        this.helpBut.setMargin(new Insets(0, 0, 0, 0));
        this.tf.setPreferredSize(new Dimension(1, this.tf.getPreferredSize().height));
        this.tf.setName("tf");
        JButton jButton = new JButton(Globals.lang("Reset"));
        jButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralFetcher.this.tf.setText("");
                new FocusRequester(GeneralFetcher.this.tf);
            }
        });
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.fetcherChoice, gridBagConstraints);
        jPanel.add(this.fetcherChoice);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.tf, gridBagConstraints);
        jPanel.add(this.tf);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        JButton jButton2 = new JButton(Globals.lang("Fetch"));
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jPanel.add(jButton2);
        jButton.setName("reset");
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.helpBut, gridBagConstraints);
        jPanel.add(this.helpBut);
        JPanel jPanel2 = new JPanel();
        if (jPanel2 != null) {
            gridBagLayout.setConstraints(this.optPanel, gridBagConstraints);
            jPanel.add(this.optPanel);
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)jPanel, "Center");
        jButton2.addActionListener(this);
        this.tf.addActionListener(this);
    }

    public void setHelpResourceOwner(Class clazz) {
        this.help.setResourceOwner(clazz);
    }

    private JTextField getTextField() {
        return this.tf;
    }

    public Action getAction() {
        return this.action;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.tf.getText().trim().length() == 0) {
            this.frame.output(Globals.lang("Please enter a search string"));
            return;
        }
        if (this.frame.basePanel() == null) {
            this.frame.output(Globals.lang("Please open or start a new database before searching"));
            return;
        }
        if (this.activeFetcher instanceof PreviewEntryFetcher) {
            this.frame.output(Globals.lang("Searching..."));
            this.frame.setProgressBarIndeterminate(true);
            this.frame.setProgressBarVisible(true);
            final PreviewEntryFetcher previewEntryFetcher = (PreviewEntryFetcher)this.activeFetcher;
            final FetcherPreviewDialog fetcherPreviewDialog = new FetcherPreviewDialog(this.frame, previewEntryFetcher.getWarningLimit(), previewEntryFetcher.getPreferredPreviewHeight());
            JabRefExecutorService.INSTANCE.execute(new Runnable(){

                @Override
                public void run() {
                    final boolean bl = previewEntryFetcher.processQueryGetPreview(GeneralFetcher.this.tf.getText().trim(), fetcherPreviewDialog, fetcherPreviewDialog);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GeneralFetcher.this.frame.setProgressBarVisible(false);
                            GeneralFetcher.this.frame.output("");
                            if (!bl) {
                                return;
                            }
                            fetcherPreviewDialog.setLocationRelativeTo(GeneralFetcher.this.frame);
                            fetcherPreviewDialog.setVisible(true);
                            if (fetcherPreviewDialog.isOkPressed()) {
                                final ImportInspectionDialog importInspectionDialog = new ImportInspectionDialog(GeneralFetcher.this.frame, GeneralFetcher.this.frame.basePanel(), BibtexFields.DEFAULT_INSPECTION_FIELDS, GeneralFetcher.this.activeFetcher.getTitle(), false);
                                importInspectionDialog.addCallBack(GeneralFetcher.this.activeFetcher);
                                Util.placeDialog(importInspectionDialog, GeneralFetcher.this.frame);
                                importInspectionDialog.setVisible(true);
                                JabRefExecutorService.INSTANCE.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        previewEntryFetcher.getEntries(fetcherPreviewDialog.getSelection(), importInspectionDialog);
                                        importInspectionDialog.entryListComplete();
                                    }
                                });
                            }
                        }
                    });
                }
            });
        } else {
            final ImportInspectionDialog importInspectionDialog = new ImportInspectionDialog(this.frame, this.frame.basePanel(), BibtexFields.DEFAULT_INSPECTION_FIELDS, this.activeFetcher.getTitle(), false);
            importInspectionDialog.addCallBack(this.activeFetcher);
            Util.placeDialog(importInspectionDialog, this.frame);
            importInspectionDialog.setVisible(true);
            JabRefExecutorService.INSTANCE.execute(new Runnable(){

                @Override
                public void run() {
                    if (GeneralFetcher.this.activeFetcher.processQuery(GeneralFetcher.this.tf.getText().trim(), importInspectionDialog, importInspectionDialog)) {
                        importInspectionDialog.entryListComplete();
                    } else {
                        importInspectionDialog.dispose();
                    }
                }
            });
        }
    }

    @Override
    public void componentClosing() {
        super.componentClosing();
        Globals.prefs.putBoolean("webSearchVisible", Boolean.FALSE);
    }

    @Override
    public void componentOpening() {
        super.componentOpening();
        Globals.prefs.putBoolean("webSearchVisible", Boolean.TRUE);
    }

    private static class EntryFetcherComparator
    implements Comparator<EntryFetcher> {
        private EntryFetcherComparator() {
        }

        @Override
        public int compare(EntryFetcher entryFetcher, EntryFetcher entryFetcher2) {
            return entryFetcher.getTitle().compareTo(entryFetcher2.getTitle());
        }
    }

    class FetcherAction
    extends AbstractAction {
        public FetcherAction() {
            super(Globals.lang("Web search"), GUIGlobals.getImage("www"));
            this.putValue("AcceleratorKey", Globals.prefs.getKey("Fetch Medline"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!GeneralFetcher.this.sidePaneManager.hasComponent(GeneralFetcher.this.getTitle())) {
                GeneralFetcher.this.sidePaneManager.register(GeneralFetcher.this.getTitle(), GeneralFetcher.this);
            }
            if (GeneralFetcher.this.frame.getTabbedPane().getTabCount() > 0) {
                GeneralFetcher.this.sidePaneManager.toggle(GeneralFetcher.this.getTitle());
                if (GeneralFetcher.this.sidePaneManager.isComponentVisible(GeneralFetcher.this.getTitle())) {
                    new FocusRequester(GeneralFetcher.this.getTextField());
                }
            }
        }
    }
}

