/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibsonomyScraper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.net.URLDownload;

public class JSTORFetcher2
implements EntryFetcher {
    private static final String CANCELLED = "__CANCELLED__";
    private static final int MAX_PAGES_TO_LOAD = 8;
    protected static int MAX_REFS = 175;
    private static final int REFS_PER_PAGE = 25;
    private static final String JSTOR_URL = "http://www.jstor.org";
    private static final String SEARCH_URL = "http://www.jstor.org/action/doBasicSearch?Query=";
    private static final String SEARCH_URL_END = "&x=0&y=0&wc=on";
    private static final String SINGLE_CIT_ENC = "http://www.jstor.org/action/exportSingleCitation?singleCitation=true&doi=10.2307/";
    private static final Pattern idPattern = Pattern.compile("<a class=\"title\" href=\"/stable/(\\d+)\\?");
    private static final Pattern numberofhits = Pattern.compile("<span id=\"NumberOfHits\" name=\"(\\d+)\"");
    private static final Pattern nextPagePattern = Pattern.compile("<a href=\"(.*)\">Next&nbsp;&raquo;");
    private static final String noAccessIndicator = "We do not recognize you as having access to JSTOR";
    private boolean stopFetching = false;
    private boolean noAccessFound = false;

    @Override
    public String getHelpPage() {
        return "JSTOR.html";
    }

    @Override
    public String getKeyName() {
        return "JSTOR";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return "JSTOR";
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
        this.noAccessFound = false;
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        this.stopFetching = false;
        try {
            List<String> list = this.getCitations(string, importInspector, outputPrinter);
            if (list == null) {
                return false;
            }
            if (list.size() == 0) {
                if (!this.noAccessFound) {
                    outputPrinter.showMessage(Globals.lang("No entries found for the search string '%0'", string), Globals.lang("Search JSTOR"), 1);
                } else {
                    outputPrinter.showMessage(Globals.lang("No entries found. It looks like you do not have access to search JStor.", string), Globals.lang("Search JSTOR"), 1);
                }
                return false;
            }
            int n = 0;
            for (String string2 : list) {
                if (this.stopFetching) break;
                BibtexEntry bibtexEntry = this.getSingleCitation(string2);
                if (bibtexEntry != null) {
                    importInspector.addEntry(bibtexEntry);
                }
                importInspector.setProgress(++n, list.size());
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            outputPrinter.showMessage(Globals.lang("Error while fetching from JSTOR") + ": " + iOException.getMessage());
            return false;
        }
    }

    private List<String> getCitations(String string, ImportInspector importInspector, OutputPrinter outputPrinter) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            String string3 = SEARCH_URL + URLEncoder.encode(string, "UTF-8") + SEARCH_URL_END;
            String[] stringArray = new String[2];
            int n = 8;
            for (int i = 1; i <= Math.min(8, n) && (string2 = this.getCitationsFromUrl(string3, arrayList, i, stringArray, importInspector, outputPrinter)) != null; ++i) {
                if (i == 1 && string2.equals(CANCELLED)) {
                    return null;
                }
                int n2 = Integer.valueOf(stringArray[1]);
                n = (n2 - 1 - (n2 - 1) % 25) / 25 + 1;
                string3 = string2;
            }
            return arrayList;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private String getCitationsFromUrl(String string, List<String> list, int n, String[] stringArray, ImportInspector importInspector, OutputPrinter outputPrinter) throws IOException {
        int n2;
        Matcher matcher;
        String string2;
        URL uRL = new URL(string);
        URLDownload uRLDownload = new URLDownload(uRL);
        String string3 = string2 = uRLDownload.downloadToString();
        String string4 = string2;
        int n3 = 0;
        if (n == 1) {
            matcher = numberofhits.matcher(string4);
            if (matcher.find()) {
                stringArray[0] = matcher.group(1);
                n3 = Integer.valueOf(stringArray[0]);
            } else {
                stringArray[0] = "0";
            }
            while (true) {
                String string5;
                if ((string5 = JOptionPane.showInputDialog(Globals.lang("References found") + ": " + n3 + "  " + Globals.lang("Number of references to fetch?"), (Object)Integer.toString(n3))) == null) {
                    outputPrinter.setStatus(Globals.lang("JSTOR import cancelled"));
                    return CANCELLED;
                }
                try {
                    stringArray[1] = string5.trim();
                    n2 = Integer.parseInt(stringArray[1]);
                }
                catch (RuntimeException runtimeException) {
                    outputPrinter.showMessage(Globals.lang("Please enter a valid number"));
                    continue;
                }
                break;
            }
        }
        n3 = Integer.valueOf(stringArray[0]);
        n2 = Integer.valueOf(stringArray[1]);
        matcher = idPattern.matcher(string2);
        if (matcher.find() && list.size() + 1 <= n2) {
            do {
                list.add(matcher.group(1));
            } while ((matcher = idPattern.matcher(string2 = string2.substring(matcher.end()))).find() && list.size() + 1 <= n2);
        } else {
            if (string3.contains(noAccessIndicator)) {
                this.noAccessFound = true;
                return null;
            }
            return null;
        }
        matcher = nextPagePattern.matcher(string3);
        if (matcher.find()) {
            return JSTOR_URL + matcher.group(1);
        }
        return null;
    }

    private BibtexEntry getSingleCitation(String string) {
        return BibsonomyScraper.getEntry(SINGLE_CIT_ENC + string);
    }
}

