/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.imports.MedlineHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MedlineImporter
extends ImportFormat {
    private static final Log LOGGER = LogFactory.getLog(MedlineImporter.class);

    @Override
    public String getFormatName() {
        return "Medline";
    }

    @Override
    public String getCLIId() {
        return "medline";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        for (int i = 0; (string = bufferedReader.readLine()) != null && i < 50; ++i) {
            if (!string.toLowerCase().contains("<pubmedarticle>")) continue;
            return true;
        }
        return false;
    }

    public static List<BibtexEntry> fetchMedline(String string, OutputPrinter outputPrinter) {
        String string2 = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&retmode=xml&rettype=citation&id=" + string;
        try {
            URL uRL = new URL(string2);
            URLConnection uRLConnection = uRL.openConnection();
            return new MedlineImporter().importEntries(uRLConnection.getInputStream(), outputPrinter);
        }
        catch (IOException iOException) {
            return new ArrayList<BibtexEntry>();
        }
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        sAXParserFactory.setNamespaceAware(true);
        ArrayList<BibtexEntry> arrayList = null;
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            MedlineHandler medlineHandler = new MedlineHandler();
            sAXParser.parse(inputStream, (DefaultHandler)medlineHandler);
            arrayList = medlineHandler.getItems();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Error with XML parser configuration", parserConfigurationException);
            outputPrinter.showMessage(parserConfigurationException.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            LOGGER.error("Error during XML parsing", sAXException);
            outputPrinter.showMessage(sAXException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            LOGGER.error("Error during file import", iOException);
            outputPrinter.showMessage(iOException.getLocalizedMessage());
        }
        return arrayList;
    }
}

