/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.MetaData;
import net.sf.jabref.imports.ImportFormatReader;

public class ParserResult {
    public static final ParserResult INVALID_FORMAT = new ParserResult(null, null, null);
    public static final ParserResult FILE_LOCKED = new ParserResult(null, null, null);
    private final BibtexDatabase base;
    private MetaData metaData;
    private final HashMap<String, BibtexEntryType> entryTypes;
    private File file = null;
    private final ArrayList<String> warnings = new ArrayList();
    private final ArrayList<String> duplicateKeys = new ArrayList();
    private String errorMessage = null;
    private String encoding = null;
    private boolean postponedAutosaveFound = false;
    private boolean invalid = false;
    private String jabrefVersion = null;
    private int jabrefMajorVersion = 0;
    private int jabrefMinorVersion = 0;
    private int jabrefMinor2Version = 0;
    private boolean toOpenTab = false;

    public ParserResult(Collection<BibtexEntry> collection) {
        this(ImportFormatReader.createDatabase(collection), null, new HashMap<String, BibtexEntryType>());
    }

    public ParserResult(BibtexDatabase bibtexDatabase, MetaData metaData, HashMap<String, BibtexEntryType> hashMap) {
        this.base = bibtexDatabase;
        this.metaData = metaData;
        this.entryTypes = hashMap;
    }

    public boolean toOpenTab() {
        return this.toOpenTab;
    }

    public void setToOpenTab(boolean bl) {
        this.toOpenTab = bl;
    }

    public String getJabrefVersion() {
        return this.jabrefVersion;
    }

    public void setJabrefVersion(String string) {
        this.jabrefVersion = string;
    }

    public int getJabrefMajorVersion() {
        return this.jabrefMajorVersion;
    }

    public void setJabrefMajorVersion(int n) {
        this.jabrefMajorVersion = n;
    }

    public int getJabrefMinorVersion() {
        return this.jabrefMinorVersion;
    }

    public void setJabrefMinorVersion(int n) {
        this.jabrefMinorVersion = n;
    }

    public int getJabrefMinor2Version() {
        return this.jabrefMinor2Version;
    }

    public void setJabrefMinor2Version(int n) {
        this.jabrefMinor2Version = n;
    }

    public BibtexDatabase getDatabase() {
        return this.base;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public HashMap<String, BibtexEntryType> getEntryTypes() {
        return this.entryTypes;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void addWarning(String string) {
        if (!this.warnings.contains(string)) {
            this.warnings.add(string);
        }
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public String[] warnings() {
        String[] stringArray = new String[this.warnings.size()];
        for (int i = 0; i < this.warnings.size(); ++i) {
            stringArray[i] = this.warnings.get(i);
        }
        return stringArray;
    }

    public void addDuplicateKey(String string) {
        if (!this.duplicateKeys.contains(string)) {
            this.duplicateKeys.add(string);
        }
    }

    public boolean hasDuplicateKeys() {
        return this.duplicateKeys.size() > 0;
    }

    public String[] getDuplicateKeys() {
        return this.duplicateKeys.toArray(new String[this.duplicateKeys.size()]);
    }

    public boolean isPostponedAutosaveFound() {
        return this.postponedAutosaveFound;
    }

    public void setPostponedAutosaveFound(boolean bl) {
        this.postponedAutosaveFound = bl;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid(boolean bl) {
        this.invalid = bl;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }
}

