/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepecNepImporter
extends ImportFormat {
    private static final Log LOGGER = LogFactory.getLog(RepecNepImporter.class);
    private static final Collection<String> recognizedFields = Arrays.asList("Keywords", "JEL", "Date", "URL", "By");
    private int line = 0;
    private String lastLine = "";
    private String preLine = "";
    private BufferedReader in = null;
    private boolean inOverviewSection = false;

    @Override
    public String getFormatName() {
        return "REPEC New Economic Papers (NEP)";
    }

    @Override
    public String getCLIId() {
        return "repecnep";
    }

    @Override
    public String getExtensions() {
        return ".txt";
    }

    @Override
    public String getDescription() {
        return "Imports a New Economics Papers-Message (see http://nep.repec.org)\nfrom the REPEC-NEP Service (see http://www.repec.org).\nTo import papers either save a NEP message as a text file and then import or\ncopy&paste the papers you want to import and make sure, one of the first lines\ncontains the line \"nep.repec.org\".";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        String string = "";
        String string2 = bufferedReader.readLine();
        for (int i = 0; i < 25 && string2 != null; ++i) {
            string = string + string2;
            string2 = bufferedReader.readLine();
        }
        return string.contains("NEP: New Economics Papers") || string.contains("nep.repec.org");
    }

    private boolean startsWithKeyword(Collection<String> collection) {
        boolean bl;
        boolean bl2 = bl = this.lastLine.indexOf(58) > 0;
        if (bl) {
            String string = this.lastLine.substring(0, this.lastLine.indexOf(58));
            bl = collection.contains(string);
        }
        return bl;
    }

    private void readLine() throws IOException {
        ++this.line;
        this.preLine = this.lastLine;
        this.lastLine = this.in.readLine();
    }

    private String readMultipleLines() throws IOException {
        String string = this.lastLine.trim();
        this.readLine();
        while (!(this.lastLine == null || this.lastLine.trim().equals("") || this.startsWithKeyword(recognizedFields) || this.isStartOfWorkingPaper())) {
            string = string + (this.lastLine.length() == 0 ? this.lastLine.trim() : " " + this.lastLine.trim());
            this.readLine();
        }
        return string;
    }

    private void parseTitleString(BibtexEntry bibtexEntry) throws IOException {
        this.lastLine = this.lastLine.substring(this.lastLine.indexOf(46) + 1, this.lastLine.length());
        bibtexEntry.setField("title", this.readMultipleLines());
    }

    private void parseAuthors(BibtexEntry bibtexEntry) throws IOException {
        String string = "";
        String string2 = "";
        while (this.lastLine != null && !this.lastLine.equals("") && !this.startsWithKeyword(recognizedFields)) {
            boolean bl;
            String string3;
            String string4 = null;
            if (this.lastLine.indexOf(40) >= 0) {
                string3 = this.lastLine.substring(0, this.lastLine.indexOf(40)).trim();
                bl = this.lastLine.indexOf(41) > 0;
                string4 = this.lastLine.substring(this.lastLine.indexOf(40) + 1, bl && this.lastLine.indexOf(41) > this.lastLine.indexOf(40) + 1 ? this.lastLine.indexOf(41) : this.lastLine.length()).trim();
            } else {
                string3 = this.lastLine.substring(0, this.lastLine.length()).trim();
                bl = true;
            }
            this.readLine();
            while (!bl && this.lastLine != null) {
                bl = this.lastLine.indexOf(41) > 0;
                string4 = string4 + this.lastLine.substring(0, bl ? this.lastLine.indexOf(41) : this.lastLine.length()).trim();
                this.readLine();
            }
            if (string3 != null) {
                string = string + (!string.equals("") ? " and " + string3 : "" + string3);
            }
            if (string4 == null) continue;
            string2 = string2 + (!string2.equals("") ? " and " + string4 : "" + string4);
        }
        if (!string.equals("")) {
            bibtexEntry.setField("author", string);
        }
        if (!string2.equals("")) {
            bibtexEntry.setField("institution", string2);
        }
    }

    private void parseAbstract(BibtexEntry bibtexEntry) throws IOException {
        String string = this.readMultipleLines();
        if (!string.equals("")) {
            bibtexEntry.setField("abstract", string);
        }
    }

    private void parseAdditionalFields(BibtexEntry bibtexEntry, boolean bl) throws IOException {
        if (this.lastLine != null && this.lastLine.trim().equals("")) {
            this.readLine();
        }
        while (this.lastLine != null && !this.isStartOfWorkingPaper() && (this.startsWithKeyword(recognizedFields) || this.lastLine.equals(""))) {
            Object object;
            Object object2;
            Object object3;
            String string = this.lastLine.equals("") ? "" : this.lastLine.substring(0, this.lastLine.indexOf(58)).trim();
            String string2 = this.lastLine = this.lastLine.equals("") ? "" : this.lastLine.substring(this.lastLine.indexOf(58) + 1, this.lastLine.length()).trim();
            if (string.equals("Keywords")) {
                object3 = this.readMultipleLines();
                object2 = ((String)object3).split("[,;]");
                object = "";
                for (String string3 : object2) {
                    object = (String)object + " '" + string3.trim() + "'";
                }
                bibtexEntry.setField("keywords", object.trim());
                continue;
            }
            if (string.equals("JEL")) {
                bibtexEntry.setField("jel", this.readMultipleLines());
                continue;
            }
            if (string.startsWith("Date")) {
                int n;
                object3 = null;
                object2 = this.readMultipleLines();
                object = new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"};
                for (n = 0; n < ((String[])object).length && object3 == null; ++n) {
                    try {
                        object3 = new SimpleDateFormat(object[n]).parse((String)object2);
                        continue;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime((Date)(object3 != null ? object3 : new Date()));
                bibtexEntry.setField("year", "" + gregorianCalendar.get(1));
                if (object3 == null || !object[n - 1].contains("MM")) continue;
                bibtexEntry.setField("month", "" + gregorianCalendar.get(2));
                continue;
            }
            if (string.startsWith("URL")) {
                if (bl) {
                    object3 = this.readMultipleLines();
                } else {
                    object3 = this.lastLine;
                    this.readLine();
                }
                bibtexEntry.setField("url", (String)object3);
                continue;
            }
            if (string.startsWith("By")) {
                this.parseAuthors(bibtexEntry);
                continue;
            }
            this.readLine();
        }
    }

    private boolean isStartOfWorkingPaper() {
        return this.lastLine.matches("\\d+\\.\\s.*") && !this.inOverviewSection && this.preLine.trim().equals("");
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        String string = null;
        this.line = 0;
        try {
            this.in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
            this.readLine();
            while (this.lastLine != null) {
                if (this.lastLine.startsWith("-----------------------------")) {
                    this.inOverviewSection = this.preLine.startsWith("In this issue we have");
                }
                if (this.isStartOfWorkingPaper()) {
                    BibtexEntry bibtexEntry = new BibtexEntry(IdGenerator.next());
                    bibtexEntry.setType(BibtexEntryType.getType("techreport"));
                    string = this.lastLine.substring(0, this.lastLine.indexOf(46));
                    this.parseTitleString(bibtexEntry);
                    if (this.startsWithKeyword(recognizedFields)) {
                        this.parseAdditionalFields(bibtexEntry, false);
                    } else {
                        this.readLine();
                        this.parseAuthors(bibtexEntry);
                        this.readLine();
                    }
                    if (!this.startsWithKeyword(recognizedFields)) {
                        this.parseAbstract(bibtexEntry);
                    }
                    this.parseAdditionalFields(bibtexEntry, true);
                    arrayList.add(bibtexEntry);
                    string = null;
                    continue;
                }
                this.preLine = this.lastLine;
                this.readLine();
            }
        }
        catch (Exception exception) {
            IOException iOException;
            String string2 = "Error in REPEC-NEP import on line " + this.line;
            if (string != null) {
                string2 = string2 + ", paper no. " + string + ": ";
            }
            string2 = string2 + exception.getMessage();
            LOGGER.error(string2, exception);
            if (!(exception instanceof IOException)) {
                exception.printStackTrace();
                iOException = new IOException(string2);
            }
            throw (IOException)iOException;
        }
        return arrayList;
    }
}

