/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class ScifinderImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "Scifinder";
    }

    @Override
    public String getCLIId() {
        return "scifinder";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        for (int i = 0; (string = bufferedReader.readLine()) != null && i < 50; ++i) {
            if (!string.trim().equals("START_RECORD")) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        String string2 = "";
        String string3 = "";
        String string4 = "";
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        String[] stringArray = stringBuilder.toString().split("START_RECORD");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("FIELD ");
            String string5 = null;
            String string6 = "";
            hashMap.clear();
            for (String string7 : stringArray2) {
                String[] stringArray3;
                if (!string7.contains(":") || (stringArray3 = new String[]{string7.substring(0, string7.indexOf(":")), string7.substring(string7.indexOf(":") + 1).trim()}).length <= 1) continue;
                if (stringArray3[0].equals("Author")) {
                    hashMap.put("author", AuthorList.fixAuthor_lastNameFirst(stringArray3[1].replaceAll(";", " and ")));
                    continue;
                }
                if (stringArray3[0].equals("Title")) {
                    hashMap.put("title", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Journal Title")) {
                    string5 = stringArray3[1];
                    continue;
                }
                if (stringArray3[0].equals("Volume")) {
                    hashMap.put("volume", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Page")) {
                    hashMap.put("pages", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Publication Year")) {
                    hashMap.put("year", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Abstract")) {
                    hashMap.put("abstract", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Supplementary Terms")) {
                    hashMap.put("keywords", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Inventor Name") && stringArray3[1].trim().length() > 0) {
                    hashMap.put("author", AuthorList.fixAuthor_lastNameFirst(stringArray3[1].replaceAll(";", " and ")));
                    continue;
                }
                if (stringArray3[0].equals("Patent Assignee")) {
                    hashMap.put("institution", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Patent Kind Code")) {
                    string4 = " " + stringArray3[1];
                    continue;
                }
                if (stringArray3[0].equals("Patent Country")) {
                    string3 = stringArray3[1] + " ";
                    continue;
                }
                if (stringArray3[0].equals("Patent Number")) {
                    string2 = stringArray3[1];
                    continue;
                }
                if (stringArray3[0].equals("Priority Application Date")) {
                    hashMap.put("number", string3 + string2 + string4);
                    continue;
                }
                if (!stringArray3[0].equals("Document Type")) continue;
                string6 = stringArray3[1].startsWith("Journal") || stringArray3[1].startsWith("Review") ? "article" : (stringArray3[1].equals("Dissertation") ? "phdthesis" : (stringArray3[1].equals("Patent") ? "patent" : (stringArray3[1].startsWith("Conference") ? "conference" : stringArray3[1])));
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string6));
            bibtexEntry.setField(hashMap);
            if (string5 != null) {
                if (string6.equals("conference")) {
                    bibtexEntry.setField("booktitle", string5);
                } else {
                    bibtexEntry.setField("journal", string5);
                }
            }
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }
}

