/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SixpackImporter
extends ImportFormat {
    private final String SEPARATOR = new String(new char[]{'\u0000', '0'});
    private static final Log LOGGER = LogFactory.getLog(SixpackImporter.class);

    @Override
    public String getFormatName() {
        return "Sixpack";
    }

    @Override
    public String getCLIId() {
        return "sixpack";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        for (int i = 0; (string = bufferedReader.readLine()) != null && i < 50; ++i) {
            if (!string.contains(this.SEPARATOR)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", "bibtexkey");
        hashMap.put("au", "author");
        hashMap.put("ti", "title");
        hashMap.put("jo", "journal");
        hashMap.put("vo", "volume");
        hashMap.put("nu", "number");
        hashMap.put("pa", "pages");
        hashMap.put("mo", "month");
        hashMap.put("yr", "year");
        hashMap.put("kw", "keywords");
        hashMap.put("ab", "abstract");
        hashMap.put("no", "note");
        hashMap.put("ed", "editor");
        hashMap.put("pu", "publisher");
        hashMap.put("se", "series");
        hashMap.put("ad", "address");
        hashMap.put("en", "edition");
        hashMap.put("ch", "chapter");
        hashMap.put("hp", "howpublished");
        hashMap.put("tb", "booktitle");
        hashMap.put("or", "organization");
        hashMap.put("sc", "school");
        hashMap.put("in", "institution");
        hashMap.put("ty", "type");
        hashMap.put("url", "url");
        hashMap.put("cr", "crossref");
        hashMap.put("fi", "file");
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        bufferedReader.readLine();
        String string2 = bufferedReader.readLine();
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(",");
        while ((string = bufferedReader.readLine()) != null) {
            try {
                String string3;
                String[] stringArray2 = (string = string.replaceAll("<par>", "")).split(this.SEPARATOR);
                if (stringArray2.length < 2) continue;
                BibtexEntryType bibtexEntryType = BibtexEntryType.getType(stringArray2[1].toLowerCase());
                if (bibtexEntryType == null) {
                    string3 = "";
                    if (stringArray2[1].equals("Masterthesis")) {
                        string3 = "mastersthesis";
                    }
                    if (stringArray2[1].equals("PhD-Thesis")) {
                        string3 = "phdthesis";
                    }
                    if (stringArray2[1].equals("miscellaneous")) {
                        string3 = "misc";
                    }
                    if (stringArray2[1].equals("Conference")) {
                        string3 = "proceedings";
                    }
                    bibtexEntryType = BibtexEntryType.getType(string3.toLowerCase());
                }
                BibtexEntry bibtexEntry = new BibtexEntry(IdGenerator.next(), bibtexEntryType);
                for (int i = 0; i < Math.min(stringArray.length, stringArray2.length); ++i) {
                    string3 = (String)hashMap.get(stringArray[i]);
                    if (string3 == null) continue;
                    if (string3.equals("author") || string3.equals("editor")) {
                        ImportFormatReader.setIfNecessary(bibtexEntry, string3, stringArray2[i].replaceAll(" and ", ", ").replaceAll(", ", " and "));
                        continue;
                    }
                    if (string3.equals("pages")) {
                        ImportFormatReader.setIfNecessary(bibtexEntry, string3, stringArray2[i].replaceAll("-", "--"));
                        continue;
                    }
                    if (string3.equals("file")) {
                        String string4 = "pdf";
                        if (stringArray2[i].endsWith("ps") || stringArray2[i].endsWith("ps.gz")) {
                            string4 = "ps";
                        } else if (stringArray2[i].endsWith("html")) {
                            string4 = "url";
                        }
                        ImportFormatReader.setIfNecessary(bibtexEntry, string4, stringArray2[i]);
                        continue;
                    }
                    ImportFormatReader.setIfNecessary(bibtexEntry, string3, stringArray2[i]);
                }
                arrayList.add(bibtexEntry);
            }
            catch (NullPointerException nullPointerException) {
                LOGGER.info("Problem parsing Sixpack entry, ignoring entry.", nullPointerException);
            }
        }
        return arrayList;
    }
}

