/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.Arrays;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.imports.LengthComparator;

public class UnitFormatter
implements LayoutFormatter {
    private static final String[] unitList = new String[]{"A", "Ah", "B", "Bq", "C", "F", "Gy", "H", "Hz", "J", "K", "N", "\\$\\\\Omega\\$", "Pa", "S", "Sa", "Sv", "T", "V", "VA", "W", "Wb", "Wh", "bar", "b", "cd", "dB", "dBm", "dBc", "eV", "inch", "kat", "lm", "lx", "m", "mol", "rad", "s", "sr"};
    private static final String[] unitPrefixList = new String[]{"y", "z", "a", "f", "p", "n", "\\$\\\\mu\\$", "u", "m", "c", "d", "", "da", "h", "k", "M", "G", "T", "P", "E", "Z", "Y"};
    private static final String[] unitCombinations;

    private String format(String string, String[] stringArray) {
        if (string == null) {
            return null;
        }
        Arrays.sort(stringArray, new LengthComparator());
        string = string.replaceAll("([0-9,\\.]+)-([Bb][Ii][Tt])", "$1\\\\mbox\\{-\\}$2");
        string = string.replaceAll("([0-9,\\.]+) ([Bb][Ii][Tt])", "$1~$2");
        for (String string2 : stringArray) {
            string = string.replaceAll("([0-9])(" + string2 + ")", "$1\\{$2\\}");
            string = string.replaceAll("([0-9])-(" + string2 + ")", "$1\\\\mbox\\{-\\}\\{$2\\}");
            string = string.replaceAll("([0-9]) (" + string2 + ")", "$1~\\{$2\\}");
        }
        return string;
    }

    @Override
    public String format(String string) {
        if (string == null) {
            return null;
        }
        return this.format(string, unitCombinations);
    }

    static {
        int n = unitList.length;
        int n2 = unitPrefixList.length;
        int n3 = n * n2;
        unitCombinations = new String[n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                UnitFormatter.unitCombinations[i * n2 + j] = unitPrefixList[j] + unitList[i];
            }
        }
    }
}

