/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.io.FileFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.FindUnlinkedFilesDialog;
import net.sf.jabref.imports.UnlinkedPDFFileFilter;

public class UnlinkedFilesCrawler {
    private final FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            return file.isDirectory();
        }
    };
    private final BibtexDatabase database;

    public UnlinkedFilesCrawler(BibtexDatabase bibtexDatabase) {
        this.database = bibtexDatabase;
    }

    public FindUnlinkedFilesDialog.CheckableTreeNode searchDirectory(File file, FileFilter fileFilter) {
        UnlinkedPDFFileFilter unlinkedPDFFileFilter = new UnlinkedPDFFileFilter(fileFilter, this.database);
        return this.searchDirectory(file, unlinkedPDFFileFilter, new int[]{1}, null);
    }

    public FindUnlinkedFilesDialog.CheckableTreeNode searchDirectory(File file, UnlinkedPDFFileFilter unlinkedPDFFileFilter, int[] nArray, ChangeListener changeListener) {
        File[] fileArray;
        if (nArray == null || nArray.length < 1 || nArray[0] != 1) {
            return null;
        }
        if (file == null || !file.exists() || !file.isDirectory()) {
            return null;
        }
        File[] fileArray2 = file.listFiles(unlinkedPDFFileFilter);
        FindUnlinkedFilesDialog.CheckableTreeNode checkableTreeNode = new FindUnlinkedFilesDialog.CheckableTreeNode(null);
        int n = 0;
        for (File file2 : fileArray = file.listFiles(this.directoryFilter)) {
            FindUnlinkedFilesDialog.CheckableTreeNode checkableTreeNode2 = this.searchDirectory(file2, unlinkedPDFFileFilter, nArray, changeListener);
            if (checkableTreeNode2 == null || checkableTreeNode2.getChildCount() <= 0) continue;
            n += ((FindUnlinkedFilesDialog.FileNodeWrapper)checkableTreeNode2.getUserObject()).fileCount;
            checkableTreeNode.add(checkableTreeNode2);
        }
        checkableTreeNode.setUserObject(new FindUnlinkedFilesDialog.FileNodeWrapper(file, fileArray2.length + n));
        for (File file2 : fileArray2) {
            checkableTreeNode.add(new FindUnlinkedFilesDialog.CheckableTreeNode(new FindUnlinkedFilesDialog.FileNodeWrapper(file2)));
            if (changeListener == null) continue;
            changeListener.stateChanged(new ChangeEvent(this));
        }
        return checkableTreeNode;
    }
}

