/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports.fetcher;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Scanner;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.CaseKeeper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.UnitFormatter;

public class ISBNtoBibTeXFetcher
implements EntryFetcher {
    private static final String URL_PATTERN = "http://www.ebook.de/de/tools/isbn2bibtex?isbn=%s";
    private final CaseKeeper caseKeeper = new CaseKeeper();
    private final UnitFormatter unitFormatter = new UnitFormatter();

    @Override
    public void stopFetching() {
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        InputStream inputStream;
        URL uRL;
        String string2;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            outputPrinter.setStatus(Globals.lang("Error"));
            unsupportedEncodingException.printStackTrace();
            return false;
        }
        String string3 = String.format(URL_PATTERN, string2);
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return false;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            outputPrinter.showMessage(Globals.lang("Invalid ISBN"));
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            outputPrinter.showMessage(Globals.lang("No_Internet_Connection."));
            return false;
        }
        catch (Exception exception) {
            outputPrinter.showMessage(exception.toString());
            return false;
        }
        String string4 = new Scanner(inputStream).useDelimiter("\\A").next();
        BibtexEntry bibtexEntry = BibtexParser.singleFromString(string4);
        if (bibtexEntry != null) {
            String string5 = bibtexEntry.getField("title");
            if (string5 != null) {
                if (Globals.prefs.getBoolean("useUnitFormatterOnSearch")) {
                    string5 = this.unitFormatter.format(string5);
                }
                if (Globals.prefs.getBoolean("useCaseKeeperOnSearch")) {
                    string5 = this.caseKeeper.format(string5);
                }
                bibtexEntry.setField("title", string5);
            }
            importInspector.addEntry(bibtexEntry);
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return "ISBN to BibTeX";
    }

    @Override
    public String getKeyName() {
        return "ISBNtoBibTeX";
    }

    @Override
    public String getHelpPage() {
        return "ISBNtoBibTeXHelp.html";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }
}

