/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.journals.JournalAbbreviationsUtil;
import net.sf.jabref.journals.logic.Abbreviation;
import net.sf.jabref.journals.logic.JournalAbbreviationRepository;
import net.sf.jabref.net.URLDownload;

class ManageJournalsPanel
extends JPanel {
    private final JabRefFrame frame;
    private final JTextField personalFile = new JTextField();
    private final AbbreviationsTableModel tableModel = new AbbreviationsTableModel();
    private JTable userTable;
    private final JPanel userPanel = new JPanel();
    private final JPanel journalEditPanel;
    private final JPanel externalFilesPanel = new JPanel();
    private final JPanel addExtPan = new JPanel();
    private final JTextField nameTf = new JTextField();
    private final JTextField newNameTf = new JTextField();
    private final JTextField abbrTf = new JTextField();
    private final List<ExternalFileEntry> externals = new ArrayList<ExternalFileEntry>();
    private final JDialog dialog;
    private final JRadioButton newFile = new JRadioButton(Globals.lang("New file"));
    private final JRadioButton oldFile = new JRadioButton(Globals.lang("Existing file"));
    private final JButton add = new JButton(GUIGlobals.getImage("add"));
    private final JButton remove = new JButton(GUIGlobals.getImage("remove"));

    public ManageJournalsPanel(final JabRefFrame jabRefFrame) {
        this.frame = jabRefFrame;
        this.personalFile.setEditable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.newFile);
        buttonGroup.add(this.oldFile);
        this.addExtPan.setLayout(new BorderLayout());
        JButton jButton = new JButton(GUIGlobals.getImage("add"));
        this.addExtPan.add((Component)jButton, "East");
        this.addExtPan.setToolTipText(Globals.lang("Add"));
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:200dlu:grow, 4dlu, fill:pref", "pref, pref, pref, 20dlu, 20dlu, fill:200dlu, 4dlu, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.addSeparator(Globals.lang("Built-in journal list"), cellConstraints.xyw(2, 1, 6));
        JLabel jLabel = new JLabel("<HTML>" + Globals.lang("JabRef includes a built-in list of journal abbreviations.") + "<br>" + Globals.lang("You can add additional journal names by setting up a personal journal list,<br>as well as linking to external journal lists.") + "</HTML>");
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        defaultFormBuilder.add((Component)jLabel, cellConstraints.xyw(2, 2, 6));
        JButton jButton2 = new JButton(Globals.lang("View"));
        defaultFormBuilder.add((Component)jButton2, cellConstraints.xy(7, 2));
        defaultFormBuilder.addSeparator(Globals.lang("Personal journal list"), cellConstraints.xyw(2, 3, 6));
        defaultFormBuilder.add((Component)this.newFile, cellConstraints.xy(3, 4));
        defaultFormBuilder.add((Component)this.newNameTf, cellConstraints.xy(5, 4));
        JButton jButton3 = new JButton(Globals.lang("Browse"));
        defaultFormBuilder.add((Component)jButton3, cellConstraints.xy(7, 4));
        defaultFormBuilder.add((Component)this.oldFile, cellConstraints.xy(3, 5));
        defaultFormBuilder.add((Component)this.personalFile, cellConstraints.xy(5, 5));
        JButton jButton4 = new JButton(Globals.lang("Browse"));
        defaultFormBuilder.add((Component)jButton4, cellConstraints.xy(7, 5));
        this.userPanel.setLayout(new BorderLayout());
        defaultFormBuilder.add((Component)this.userPanel, cellConstraints.xyw(2, 6, 4));
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addButton((JComponent)this.add);
        buttonStackBuilder.addButton((JComponent)this.remove);
        buttonStackBuilder.addGlue();
        defaultFormBuilder.add((Component)buttonStackBuilder.getPanel(), cellConstraints.xy(7, 6));
        defaultFormBuilder.addSeparator(Globals.lang("External files"), cellConstraints.xyw(2, 8, 6));
        this.externalFilesPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)defaultFormBuilder.getPanel(), "North");
        this.add((Component)this.externalFilesPanel, "Center");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        JButton jButton5 = new JButton(Globals.lang("Ok"));
        buttonBarBuilder.addButton((JComponent)jButton5);
        JButton jButton6 = new JButton(Globals.lang("Cancel"));
        buttonBarBuilder.addButton((JComponent)jButton6);
        buttonBarBuilder.addUnrelatedGap();
        JButton jButton7 = new JButton(Globals.lang("Help"));
        buttonBarBuilder.addButton((JComponent)jButton7);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.dialog = new JDialog(jabRefFrame, Globals.lang("Journal abbreviations"), false);
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        FormLayout formLayout2 = new FormLayout("right:pref, 4dlu, fill:180dlu", "");
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(formLayout2);
        defaultFormBuilder2.append(Globals.lang("Journal name"));
        defaultFormBuilder2.append(this.nameTf);
        defaultFormBuilder2.nextLine();
        defaultFormBuilder2.append(Globals.lang("ISO abbreviation"));
        defaultFormBuilder2.append(this.abbrTf);
        this.journalEditPanel = defaultFormBuilder2.getPanel();
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JournalAbbreviationRepository journalAbbreviationRepository = new JournalAbbreviationRepository();
                journalAbbreviationRepository.readJournalListFromResource("/resource/journalList.txt");
                JTable jTable = new JTable(JournalAbbreviationsUtil.getTableModel(Globals.journalAbbrev));
                JScrollPane jScrollPane = new JScrollPane(jTable);
                JOptionPane.showMessageDialog(null, jScrollPane, Globals.lang("Journal list preview"), 1);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                File file = null;
                if (!ManageJournalsPanel.this.newNameTf.getText().equals("")) {
                    file = new File(ManageJournalsPanel.this.newNameTf.getText());
                }
                if ((string = FileDialogs.getNewFile(jabRefFrame, file, null, 1, false)) != null) {
                    ManageJournalsPanel.this.newNameTf.setText(string);
                    ManageJournalsPanel.this.newFile.setSelected(true);
                }
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                File file = null;
                if (!ManageJournalsPanel.this.personalFile.getText().equals("")) {
                    file = new File(ManageJournalsPanel.this.personalFile.getText());
                }
                if ((string = FileDialogs.getNewFile(jabRefFrame, file, null, 0, false)) != null) {
                    ManageJournalsPanel.this.personalFile.setText(string);
                    ManageJournalsPanel.this.oldFile.setSelected(true);
                    ManageJournalsPanel.this.oldFile.setEnabled(true);
                    ManageJournalsPanel.this.setupUserTable();
                }
            }
        });
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ManageJournalsPanel.this.readyToClose()) {
                    try {
                        ManageJournalsPanel.this.storeSettings();
                        ManageJournalsPanel.this.dialog.dispose();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        JOptionPane.showMessageDialog(null, Globals.lang("Error opening file") + ": " + fileNotFoundException.getMessage(), Globals.lang("Error opening file"), 0);
                    }
                }
            }
        });
        jButton7.addActionListener(new HelpAction(Globals.helpDiag, "JournalAbbreviations.html"));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManageJournalsPanel.this.dialog.dispose();
            }
        };
        jButton6.addActionListener(abstractAction);
        this.add.addActionListener(this.tableModel);
        this.remove.addActionListener(this.tableModel);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManageJournalsPanel.this.externals.add(new ExternalFileEntry());
                ManageJournalsPanel.this.buildExternalsPanel();
            }
        });
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        int n = this.getPreferredSize().width;
        this.dialog.setSize(n + 10, 700);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setValues() {
        this.personalFile.setText(Globals.prefs.get("personalJournalList"));
        if (this.personalFile.getText().length() == 0) {
            this.newFile.setSelected(true);
            this.oldFile.setEnabled(false);
        } else {
            this.oldFile.setSelected(true);
            this.oldFile.setEnabled(true);
        }
        this.setupUserTable();
        this.setupExternals();
        this.buildExternalsPanel();
    }

    private void buildExternalsPanel() {
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("fill:pref:grow", ""));
        for (ExternalFileEntry externalFileEntry : this.externals) {
            defaultFormBuilder.append(externalFileEntry.getPanel());
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append(Box.createVerticalGlue());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.addExtPan);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Box.createVerticalGlue());
        JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.externalFilesPanel.setMinimumSize(new Dimension(400, 400));
        this.externalFilesPanel.setPreferredSize(new Dimension(400, 400));
        this.externalFilesPanel.removeAll();
        this.externalFilesPanel.add((Component)jScrollPane, "Center");
        this.externalFilesPanel.revalidate();
        this.externalFilesPanel.repaint();
    }

    private void setupExternals() {
        String[] stringArray = Globals.prefs.getStringArray("externalJournalLists");
        if (stringArray == null || stringArray.length == 0) {
            ExternalFileEntry externalFileEntry = new ExternalFileEntry();
            this.externals.add(externalFileEntry);
        } else {
            for (String string : stringArray) {
                ExternalFileEntry externalFileEntry = new ExternalFileEntry(string);
                this.externals.add(externalFileEntry);
            }
        }
    }

    private void setupUserTable() {
        JournalAbbreviationRepository journalAbbreviationRepository = new JournalAbbreviationRepository();
        String string = this.personalFile.getText();
        if (!string.equals("") && new File(string).exists()) {
            try {
                journalAbbreviationRepository.readJournalListFromFile(new File(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        this.tableModel.setJournals(journalAbbreviationRepository.getAbbreviations());
        this.userTable = new JTable(this.tableModel);
        this.userTable.addMouseListener(this.tableModel.getMouseListener());
        this.userPanel.add((Component)new JScrollPane(this.userTable), "Center");
    }

    private boolean readyToClose() {
        if (this.newFile.isSelected()) {
            if (this.newNameTf.getText().length() > 0) {
                File file = new File(this.newNameTf.getText());
                return !file.exists() || JOptionPane.showConfirmDialog(this, "'" + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Store journal abbreviations"), 2) == 0;
            }
            if (this.tableModel.getRowCount() > 0) {
                JOptionPane.showMessageDialog(this, Globals.lang("You must choose a file name to store journal abbreviations"), Globals.lang("Store journal abbreviations"), 0);
                return false;
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSettings() throws FileNotFoundException {
        String[] stringArray;
        Object object;
        File file = null;
        if (this.newFile.isSelected()) {
            if (this.newNameTf.getText().length() > 0) {
                file = new File(this.newNameTf.getText());
            }
        } else {
            file = new File(this.personalFile.getText());
        }
        if (file != null) {
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            object = null;
            try {
                object = new FileWriter(file, false);
                for (JournalEntry object2 : this.tableModel.getJournals()) {
                    ((Writer)object).write(object2.name);
                    ((Writer)object).write(" = ");
                    ((Writer)object).write(object2.abbreviation);
                    ((Writer)object).write(Globals.NEWLINE);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (object != null) {
                    try {
                        ((OutputStreamWriter)object).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            stringArray = file.getPath();
            if (stringArray.equals("")) {
                stringArray = null;
            }
            Globals.prefs.put("personalJournalList", (String)stringArray);
        }
        object = new ArrayList();
        for (ExternalFileEntry externalFileEntry : this.externals) {
            if (externalFileEntry.getValue().equals("")) continue;
            ((ArrayList)object).add(externalFileEntry.getValue());
        }
        if (((ArrayList)object).size() == 0) {
            Globals.prefs.put("externalJournalLists", "");
        } else {
            stringArray = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
            Globals.prefs.putStringArray("externalJournalLists", stringArray);
        }
        Globals.initializeJournalNames();
        for (int i = 0; i < this.frame.baseCount(); ++i) {
            this.frame.baseAt(i).getAutoCompleters().addJournalListToAutoCompleter();
        }
    }

    static class JournalEntry
    implements Comparable<JournalEntry> {
        String name;
        String abbreviation;

        public JournalEntry(String string, String string2) {
            this.name = string;
            this.abbreviation = string2;
        }

        @Override
        public int compareTo(JournalEntry journalEntry) {
            return this.name.compareTo(journalEntry.name);
        }
    }

    class ExternalFileEntry {
        private JPanel pan;
        private final JTextField tf;
        private final JButton browse = new JButton(Globals.lang("Browse"));
        private final JButton view = new JButton(Globals.lang("Preview"));
        private final JButton clear = new JButton(GUIGlobals.getImage("delete"));
        private final JButton download = new JButton(Globals.lang("Download"));

        public ExternalFileEntry() {
            this.tf = new JTextField();
            this.setupPanel();
        }

        public ExternalFileEntry(String string) {
            this.tf = new JTextField(string);
            this.setupPanel();
        }

        private void setupPanel() {
            this.tf.setEditable(false);
            BrowseAction browseAction = new BrowseAction(this.tf, false);
            this.browse.addActionListener(browseAction);
            DownloadAction downloadAction = new DownloadAction(this.tf);
            this.download.addActionListener(downloadAction);
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("fill:pref:grow, 4dlu, fill:pref, 4dlu, fill:pref, 4dlu, fill:pref, 4dlu, fill:pref", ""));
            defaultFormBuilder.append(this.tf);
            defaultFormBuilder.append(this.browse);
            defaultFormBuilder.append(this.download);
            defaultFormBuilder.append(this.view);
            defaultFormBuilder.append(this.clear);
            this.pan = defaultFormBuilder.getPanel();
            this.view.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JournalAbbreviationRepository journalAbbreviationRepository = new JournalAbbreviationRepository();
                        journalAbbreviationRepository.readJournalListFromFile(new File(ExternalFileEntry.this.tf.getText()));
                        JTable jTable = new JTable(JournalAbbreviationsUtil.getTableModel(Globals.journalAbbrev));
                        JScrollPane jScrollPane = new JScrollPane(jTable);
                        JOptionPane.showMessageDialog(null, jScrollPane, Globals.lang("Journal list preview"), 1);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        JOptionPane.showMessageDialog(null, Globals.lang("File '%0' not found", ExternalFileEntry.this.tf.getText()), Globals.lang("Error"), 0);
                    }
                }
            });
            this.clear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageJournalsPanel.this.externals.remove(ExternalFileEntry.this);
                    ManageJournalsPanel.this.buildExternalsPanel();
                }
            });
            this.clear.setToolTipText(Globals.lang("Remove"));
        }

        public JPanel getPanel() {
            return this.pan;
        }

        public String getValue() {
            return this.tf.getText();
        }
    }

    class AbbreviationsTableModel
    extends AbstractTableModel
    implements ActionListener {
        final String[] names = new String[]{Globals.lang("Journal name"), Globals.lang("Abbreviation")};
        List<JournalEntry> journals = null;

        public void setJournals(SortedSet<Abbreviation> sortedSet) {
            this.journals = new ArrayList<JournalEntry>();
            for (Abbreviation abbreviation : sortedSet) {
                this.journals.add(new JournalEntry(abbreviation.getName(), abbreviation.getIsoAbbreviation()));
            }
            this.fireTableDataChanged();
        }

        public List<JournalEntry> getJournals() {
            return this.journals;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.journals.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.journals.get((int)n).name;
            }
            return this.journals.get((int)n).abbreviation;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            JournalEntry journalEntry = this.journals.get(n);
            if (n2 == 0) {
                journalEntry.name = (String)object;
            } else {
                journalEntry.abbreviation = (String)object;
            }
        }

        @Override
        public String getColumnName(int n) {
            return this.names[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public MouseListener getMouseListener() {
            return new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        JTable jTable = (JTable)mouseEvent.getSource();
                        int n = jTable.rowAtPoint(mouseEvent.getPoint());
                        ManageJournalsPanel.this.nameTf.setText((String)AbbreviationsTableModel.this.getValueAt(n, 0));
                        ManageJournalsPanel.this.abbrTf.setText((String)AbbreviationsTableModel.this.getValueAt(n, 1));
                        if (JOptionPane.showConfirmDialog(ManageJournalsPanel.this.dialog, ManageJournalsPanel.this.journalEditPanel, Globals.lang("Edit journal"), 2) == 0) {
                            AbbreviationsTableModel.this.setValueAt(ManageJournalsPanel.this.nameTf.getText(), n, 0);
                            AbbreviationsTableModel.this.setValueAt(ManageJournalsPanel.this.abbrTf.getText(), n, 1);
                            Collections.sort(AbbreviationsTableModel.this.journals);
                            AbbreviationsTableModel.this.fireTableDataChanged();
                        }
                    }
                }
            };
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            if (actionEvent.getSource() == ManageJournalsPanel.this.add) {
                ManageJournalsPanel.this.nameTf.setText("");
                ManageJournalsPanel.this.abbrTf.setText("");
                if (JOptionPane.showConfirmDialog(ManageJournalsPanel.this.dialog, ManageJournalsPanel.this.journalEditPanel, Globals.lang("Edit journal"), 2) == 0) {
                    this.journals.add(new JournalEntry(ManageJournalsPanel.this.nameTf.getText(), ManageJournalsPanel.this.abbrTf.getText()));
                    Collections.sort(this.journals);
                    this.fireTableDataChanged();
                }
            } else if (actionEvent.getSource() == ManageJournalsPanel.this.remove && (nArray = ManageJournalsPanel.this.userTable.getSelectedRows()).length > 0) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.journals.remove(nArray[i]);
                }
                this.fireTableDataChanged();
            }
        }
    }

    class BrowseAction
    extends AbstractAction {
        final JTextField comp;
        final boolean dir;

        public BrowseAction(JTextField jTextField, boolean bl) {
            super(Globals.lang("Browse"));
            this.dir = bl;
            this.comp = jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.dir ? FileDialogs.getNewDir(ManageJournalsPanel.this.frame, new File(this.comp.getText()), "_non__", 0, false) : FileDialogs.getNewFile(ManageJournalsPanel.this.frame, new File(this.comp.getText()), "_non__", 0, false);
            if (string != null) {
                File file = new File(string);
                this.comp.setText(file.getPath());
            }
        }
    }

    class DownloadAction
    extends AbstractAction {
        final JTextField comp;

        public DownloadAction(JTextField jTextField) {
            super(Globals.lang("Download"));
            this.comp = jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(Globals.lang("Choose the URL to download. The default value points to a list provided by the JabRef developers."), (Object)"http://jabref.sf.net/journals/journal_abbreviations_general.txt");
            if (string == null) {
                return;
            }
            try {
                URL uRL = new URL(string);
                String string2 = FileDialogs.getNewFile(ManageJournalsPanel.this.frame, new File(System.getProperty("user.home")), null, 1, false);
                if (string2 == null) {
                    return;
                }
                File file = new File(string2);
                URLDownload.buildMonitoredDownload(this.comp, uRL).downloadToFile(file);
                this.comp.setText(file.getPath());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, Globals.lang("Error downloading file '%0'", string), Globals.lang("Download failed"), 0);
            }
        }
    }
}

