/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import javax.swing.undo.CompoundEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.journals.logic.Abbreviation;
import net.sf.jabref.journals.logic.JournalAbbreviationRepository;
import net.sf.jabref.undo.UndoableFieldChange;

public class UndoableUnabbreviator {
    private final JournalAbbreviationRepository journalAbbreviationRepository;

    public UndoableUnabbreviator(JournalAbbreviationRepository journalAbbreviationRepository) {
        this.journalAbbreviationRepository = journalAbbreviationRepository;
    }

    public boolean unabbreviate(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry, String string, CompoundEdit compoundEdit) {
        String string2 = bibtexEntry.getField(string);
        if (string2 == null) {
            return false;
        }
        String string3 = string2;
        if (bibtexDatabase != null) {
            string2 = bibtexDatabase.resolveForStrings(string2);
        }
        if (!this.journalAbbreviationRepository.isKnownName(string2)) {
            return false;
        }
        if (!this.journalAbbreviationRepository.isAbbreviatedName(string2)) {
            return false;
        }
        Abbreviation abbreviation = this.journalAbbreviationRepository.getAbbreviation(string2).get();
        String string4 = abbreviation.getName();
        bibtexEntry.setField(string, string4);
        compoundEdit.addEdit(new UndoableFieldChange(bibtexEntry, string, string3, string4));
        return true;
    }
}

