/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals.logic;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jabref.journals.logic.Abbreviation;
import net.sf.jabref.journals.logic.AbbreviationParser;

public class JournalAbbreviationRepository {
    private final HashMap<String, Abbreviation> fullNameLowerCase2Abbreviation = new HashMap();
    private final HashMap<String, Abbreviation> isoLowerCase2Abbreviation = new HashMap();
    private final HashMap<String, Abbreviation> medlineLowerCase2Abbreviation = new HashMap();
    private final SortedSet<Abbreviation> abbreviations = new TreeSet<Abbreviation>();

    public void readJournalListFromResource(String string) {
        AbbreviationParser abbreviationParser = new AbbreviationParser();
        abbreviationParser.readJournalListFromResource(Preconditions.checkNotNull(string));
        for (Abbreviation abbreviation : abbreviationParser.getAbbreviations()) {
            this.addEntry(abbreviation);
        }
    }

    public void readJournalListFromFile(File file) throws FileNotFoundException {
        AbbreviationParser abbreviationParser = new AbbreviationParser();
        abbreviationParser.readJournalListFromFile(Preconditions.checkNotNull(file));
        for (Abbreviation abbreviation : abbreviationParser.getAbbreviations()) {
            this.addEntry(abbreviation);
        }
    }

    public int size() {
        return this.abbreviations.size();
    }

    public boolean isKnownName(String string) {
        String string2 = Preconditions.checkNotNull(string).trim().toLowerCase();
        return this.fullNameLowerCase2Abbreviation.get(string2) != null || this.isoLowerCase2Abbreviation.get(string2) != null || this.medlineLowerCase2Abbreviation.get(string2) != null;
    }

    public boolean isAbbreviatedName(String string) {
        String string2 = Preconditions.checkNotNull(string).trim().toLowerCase();
        return this.isoLowerCase2Abbreviation.get(string2) != null || this.medlineLowerCase2Abbreviation.get(string2) != null;
    }

    public Optional<Abbreviation> getAbbreviation(String string) {
        String string2 = Preconditions.checkNotNull(string).toLowerCase().trim();
        if (this.fullNameLowerCase2Abbreviation.containsKey(string2)) {
            return Optional.of(this.fullNameLowerCase2Abbreviation.get(string2));
        }
        if (this.isoLowerCase2Abbreviation.containsKey(string2)) {
            return Optional.of(this.isoLowerCase2Abbreviation.get(string2));
        }
        if (this.medlineLowerCase2Abbreviation.containsKey(string2)) {
            return Optional.of(this.medlineLowerCase2Abbreviation.get(string2));
        }
        return Optional.absent();
    }

    public void addEntry(Abbreviation abbreviation) {
        Preconditions.checkNotNull(abbreviation);
        if (this.isKnownName(abbreviation.getName())) {
            Abbreviation abbreviation2 = this.getAbbreviation(abbreviation.getName()).get();
            this.abbreviations.remove(abbreviation2);
        }
        this.abbreviations.add(abbreviation);
        this.fullNameLowerCase2Abbreviation.put(abbreviation.getName().toLowerCase(), abbreviation);
        this.isoLowerCase2Abbreviation.put(abbreviation.getIsoAbbreviation().toLowerCase(), abbreviation);
        this.medlineLowerCase2Abbreviation.put(abbreviation.getMedlineAbbreviation().toLowerCase(), abbreviation);
    }

    public SortedSet<Abbreviation> getAbbreviations() {
        return Collections.unmodifiableSortedSet(this.abbreviations);
    }

    public Optional<String> getNextAbbreviation(String string) {
        Optional<Abbreviation> optional = this.getAbbreviation(string);
        if (!optional.isPresent()) {
            return Optional.absent();
        }
        Abbreviation abbreviation = optional.get();
        return Optional.of(abbreviation.getNext(string));
    }

    public Optional<String> getMedlineAbbreviation(String string) {
        Optional<Abbreviation> optional = this.getAbbreviation(string);
        if (!optional.isPresent()) {
            return Optional.absent();
        }
        Abbreviation abbreviation = optional.get();
        return Optional.of(abbreviation.getMedlineAbbreviation());
    }

    public Optional<String> getIsoAbbreviation(String string) {
        Optional<Abbreviation> optional = this.getAbbreviation(string);
        if (!optional.isPresent()) {
            return Optional.absent();
        }
        Abbreviation abbreviation = optional.get();
        return Optional.of(abbreviation.getIsoAbbreviation());
    }

    public String toPropertiesString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Abbreviation abbreviation : this.getAbbreviations()) {
            stringBuilder.append(String.format("%s%n", abbreviation.toPropertiesLine()));
        }
        return stringBuilder.toString();
    }
}

