/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.labelPattern;

import java.util.ArrayList;
import java.util.Hashtable;
import net.sf.jabref.labelPattern.LabelPatternUtil;

public class LabelPattern
extends Hashtable<String, ArrayList<String>> {
    private ArrayList<String> defaultPattern = null;
    private LabelPattern parent = null;

    public LabelPattern() {
    }

    public LabelPattern(LabelPattern labelPattern) {
        this.parent = labelPattern;
    }

    public void setParent(LabelPattern labelPattern) {
        this.parent = labelPattern;
    }

    public LabelPattern getParent() {
        return this.parent;
    }

    public void addLabelPattern(String string, String string2) {
        this.put(string, LabelPatternUtil.split(string2));
    }

    public void removeLabelPattern(String string) {
        if (this.containsKey(string) && this.parent != null) {
            this.remove(string);
        }
    }

    public void removeLabelPattern(String string, boolean bl) {
        if (this.containsKey(string) && bl) {
            this.remove(string);
        }
    }

    public final ArrayList<String> getValue(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.get(string);
        if (arrayList == null && (arrayList = this.getDefaultValue()) == null) {
            if (this.parent != null) {
                arrayList = this.parent.getValue(string);
            } else {
                return LabelPatternUtil.DEFAULT_LABELPATTERN;
            }
        }
        return arrayList;
    }

    public final boolean isDefaultValue(String string) {
        Object v = this.get(string);
        return v == null;
    }

    public ArrayList<String> getDefaultValue() {
        return this.defaultPattern;
    }

    public void setDefaultValue(String string) {
        this.defaultPattern = LabelPatternUtil.split(string);
    }
}

