/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.remote.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import net.sf.jabref.remote.server.MessageHandler;
import net.sf.jabref.remote.shared.Protocol;

public class RemoteListenerServer
implements Runnable {
    private static final int BACKLOG = 1;
    private static final int ONE_SECOND_TIMEOUT = 1000;
    private final MessageHandler messageHandler;
    private final ServerSocket serverSocket;

    public RemoteListenerServer(MessageHandler messageHandler, int n) throws IOException {
        this.serverSocket = new ServerSocket(n, 1, InetAddress.getByName("localhost"));
        this.messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                Socket socket;
                block14: {
                    socket = this.serverSocket.accept();
                    socket.setSoTimeout(1000);
                    if (!Thread.interrupted()) break block14;
                    return;
                }
                try {
                    Protocol protocol = new Protocol(socket);
                    try {
                        protocol.sendMessage("jabref");
                        String string = protocol.receiveMessage();
                        if (string.isEmpty()) continue;
                        this.messageHandler.handleMessage(string);
                    }
                    finally {
                        protocol.close();
                    }
                }
                catch (SocketException socketException) {
                    this.closeServerSocket();
                    return;
                }
                catch (IOException iOException) {
                    try {
                        iOException.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.closeServerSocket();
        }
    }

    public void closeServerSocket() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

