/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.specialfields;

import net.sf.jabref.BaseAction;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.specialfields.SpecialField;
import net.sf.jabref.specialfields.SpecialFieldsUtils;
import net.sf.jabref.undo.NamedCompound;

public class SpecialFieldAction
implements BaseAction {
    private final JabRefFrame frame;
    private final String doneTextPattern;
    private final SpecialField c;
    private final String value;
    private final boolean nullFieldIfValueIsTheSame;
    private final String undoText;

    public SpecialFieldAction(JabRefFrame jabRefFrame, SpecialField specialField, String string, boolean bl, String string2, String string3) {
        this.frame = jabRefFrame;
        this.c = specialField;
        this.value = string;
        this.nullFieldIfValueIsTheSame = bl;
        this.undoText = string2;
        this.doneTextPattern = string3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void action() {
        try {
            NamedCompound namedCompound = new NamedCompound(this.undoText);
            BibtexEntry[] bibtexEntryArray = this.frame.basePanel().getSelectedEntries();
            if (bibtexEntryArray == null) {
                return;
            }
            for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                SpecialFieldsUtils.updateField(this.c, this.value, bibtexEntry, namedCompound, this.nullFieldIfValueIsTheSame);
            }
            namedCompound.end();
            if (namedCompound.hasEdits()) {
                void var3_7;
                this.frame.basePanel().undoManager.addEdit(namedCompound);
                this.frame.basePanel().markBaseChanged();
                this.frame.basePanel().updateEntryEditorIfShowing();
                if (this.nullFieldIfValueIsTheSame) {
                    String string = Globals.lang(this.doneTextPattern, Integer.toString(bibtexEntryArray.length));
                } else {
                    String string = Globals.lang(this.doneTextPattern, this.value, Integer.toString(bibtexEntryArray.length));
                }
                this.frame.output((String)var3_7);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

