/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.specialfields;

import com.jgoodies.looks.HeaderStyle;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.specialfields.SpecialField;
import net.sf.jabref.specialfields.SpecialFieldValue;

public class SpecialFieldDropDown {
    public static JButton generateSpecialFieldButtonWithDropDown(SpecialField specialField, JabRefFrame jabRefFrame) {
        Dimension dimension = new Dimension(23, 23);
        JButton jButton = new JButton(specialField.getRepresentingIcon());
        jButton.setToolTipText(specialField.getToolTip());
        jButton.setPreferredSize(dimension);
        if (!Globals.ON_MAC) {
            jButton.setMargin(new Insets(1, 0, 2, 0));
        }
        jButton.setBorder(null);
        jButton.setBorderPainted(false);
        jButton.setRolloverEnabled(true);
        jButton.setOpaque(false);
        jButton.setBounds(0, 0, dimension.width, dimension.height);
        jButton.setSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setMaximumSize(dimension);
        jButton.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        jButton.addActionListener(new MenuButtonActionListener(specialField, jabRefFrame, jButton, dimension));
        return jButton;
    }

    private static class MenuButtonActionListener
    implements ActionListener {
        private JPopupMenu popup;
        private final Dimension dim;
        private final JabRefFrame frame;
        private final SpecialField field;
        private final JButton button;

        public MenuButtonActionListener(SpecialField specialField, JabRefFrame jabRefFrame, JButton jButton, Dimension dimension) {
            this.field = specialField;
            this.dim = dimension;
            this.frame = jabRefFrame;
            this.button = jButton;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.popup == null) {
                this.popup = new JPopupMenu();
                for (SpecialFieldValue specialFieldValue : this.field.getValues()) {
                    JMenuItem jMenuItem = new JMenuItem(specialFieldValue.getIcon());
                    jMenuItem.setText(specialFieldValue.getMenuString());
                    jMenuItem.setToolTipText(specialFieldValue.getToolTipText());
                    jMenuItem.addActionListener(new PopupitemActionListener(this.frame.basePanel(), specialFieldValue.getActionName()));
                    jMenuItem.setMargin(new Insets(0, 0, 0, 0));
                    this.popup.add(jMenuItem);
                }
            }
            this.popup.show(this.button, 0, this.dim.height);
        }

        private class PopupitemActionListener
        implements ActionListener {
            private final BasePanel panel;
            private final String actionName;

            public PopupitemActionListener(BasePanel basePanel, String string) {
                this.panel = basePanel;
                this.actionName = string;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.panel.runCommand(this.actionName);
                MenuButtonActionListener.this.popup.setVisible(false);
            }
        }
    }
}

