/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql;

import net.sf.jabref.sql.exporter.DBExporter;
import net.sf.jabref.sql.exporter.MySQLExporter;
import net.sf.jabref.sql.exporter.PostgreSQLExporter;
import net.sf.jabref.sql.importer.DBImporter;
import net.sf.jabref.sql.importer.MySQLImporter;
import net.sf.jabref.sql.importer.PostgreSQLImporter;

public class DBExporterAndImporterFactory {
    private DBExporter getExporter(DBType dBType) {
        DBExporter dBExporter = null;
        switch (dBType) {
            case MYSQL: {
                dBExporter = MySQLExporter.getInstance();
                break;
            }
            case POSTGRESQL: {
                dBExporter = PostgreSQLExporter.getInstance();
            }
        }
        return dBExporter;
    }

    public DBExporter getExporter(String string) {
        return this.getExporter(DBType.valueOf(string.toUpperCase()));
    }

    private DBImporter getImporter(DBType dBType) {
        DBImporter dBImporter = null;
        switch (dBType) {
            case MYSQL: {
                dBImporter = MySQLImporter.getInstance();
                break;
            }
            case POSTGRESQL: {
                dBImporter = PostgreSQLImporter.getInstance();
            }
        }
        return dBImporter;
    }

    public DBImporter getImporter(String string) {
        return this.getImporter(DBType.valueOf(string.toUpperCase()));
    }

    public static enum DBType {
        MYSQL("MYSQL"),
        POSTGRESQL("POSTGRESQL");

        private final String dbType;

        private DBType(String string2) {
            this.dbType = string2;
        }

        public String getDBType() {
            return this.dbType;
        }
    }
}

