/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql;

import java.awt.event.ActionEvent;
import java.sql.Connection;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.sf.jabref.BaseAction;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.sql.DBConnectDialog;
import net.sf.jabref.sql.DBExporterAndImporterFactory;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.sql.exporter.DBExporter;
import net.sf.jabref.util.Util;

public class DbConnectAction
implements BaseAction {
    private final BasePanel panel;

    public DbConnectAction(BasePanel basePanel) {
        this.panel = basePanel;
    }

    public AbstractAction getAction() {
        return new DbImpAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void action() {
        DBStrings dBStrings = this.panel.metaData().getDBStrings();
        if (!dBStrings.isInitialized()) {
            dBStrings.initialize();
        }
        DBConnectDialog dBConnectDialog = new DBConnectDialog(this.panel.frame(), dBStrings);
        Util.placeDialog(dBConnectDialog, this.panel);
        dBConnectDialog.setVisible(true);
        if (dBConnectDialog.getConnectToDB()) {
            dBStrings = dBConnectDialog.getDBStrings();
            try {
                this.panel.frame().output(Globals.lang("Establishing SQL connection..."));
                DBExporter dBExporter = new DBExporterAndImporterFactory().getExporter(dBStrings.getServerType());
                Connection connection = dBExporter.connectToDB(dBStrings);
                connection.close();
                dBStrings.isConfigValid(true);
                this.panel.frame().output(Globals.lang("SQL connection established."));
            }
            catch (Exception exception) {
                String string = SQLUtil.getExceptionMessage(exception);
                dBStrings.isConfigValid(false);
                String string2 = "Could not connect to SQL database for the following reason:";
                this.panel.frame().output(Globals.lang(string2) + "  " + string);
                JOptionPane.showMessageDialog(this.panel.frame(), Globals.lang(string2) + '\n' + string, Globals.lang("Connect to SQL database"), 0);
            }
            finally {
                this.panel.metaData().setDBStrings(dBStrings);
                dBConnectDialog.dispose();
            }
        }
    }

    private class DbImpAction
    extends AbstractAction {
        private DbImpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DbConnectAction.this.action();
        }
    }
}

