/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.IdGenerator;

public class UndoableInsertEntry
extends AbstractUndoableEdit {
    private final BibtexDatabase base;
    private final BibtexEntry entry;
    private final BasePanel panel;

    public UndoableInsertEntry(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry, BasePanel basePanel) {
        this.base = bibtexDatabase;
        this.entry = bibtexEntry;
        this.panel = basePanel;
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo: insert entry";
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo: insert entry";
    }

    @Override
    public void undo() {
        super.undo();
        try {
            this.base.removeEntry(this.entry.getId());
            this.panel.ensureNotShowing(this.entry);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void redo() {
        super.redo();
        try {
            String string = IdGenerator.next();
            this.entry.setId(string);
            this.base.insertEntry(this.entry);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

