/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import net.sf.jabref.Globals;

public class StringUtil {
    public static String shaveString(String string) {
        char c;
        if (string == null) {
            return null;
        }
        int n = 0;
        int n2 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            if (n < string.length()) {
                c = string.charAt(n);
                if (Character.isWhitespace(c)) {
                    ++n;
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
        while (!bl2) {
            if (n2 > n + 1) {
                c = string.charAt(n2 - 1);
                if (Character.isWhitespace(c)) {
                    --n2;
                    continue;
                }
                bl2 = true;
                continue;
            }
            bl2 = true;
        }
        if (n2 > n + 1) {
            c = string.charAt(n);
            char c2 = string.charAt(n2 - 1);
            if (c == '{' && c2 == '}' || c == '\"' && c2 == '\"') {
                ++n;
                --n2;
            }
        }
        string = string.substring(n, n2);
        return string;
    }

    private static String rtrim(String string) {
        return string.replaceAll("\\s+$", "");
    }

    public static String join(String[] stringArray, String string, int n, int n2) {
        if (stringArray.length == 0 || n >= n2) {
            return "";
        }
        n = Math.max(n, 0);
        n2 = Math.min(stringArray.length, n2);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2 - 1; ++i) {
            stringBuilder.append(stringArray[i]).append(string);
        }
        return stringBuilder.append(stringArray[n2 - 1]).toString();
    }

    public static String join(String[] stringArray, String string) {
        return StringUtil.join(stringArray, string, 0, stringArray.length);
    }

    public static String toUpperFirstLetter(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String[] split(String string, String string2) {
        if (string == null) {
            return null;
        }
        return string.split(string2);
    }

    public static String nCase(String string) {
        if (string.length() > 1) {
            return string.substring(0, 1).toUpperCase() + string.substring(1, string.length()).toLowerCase();
        }
        return string.toUpperCase();
    }

    public static String stripBrackets(String string) {
        int n = string.startsWith("[") ? 1 : 0;
        int n2 = string.endsWith("]") ? string.length() - 1 : string.length();
        return string.substring(n, n2);
    }

    public static String getCorrectFileName(String string, String string2) {
        if (string == null) {
            return "";
        }
        String string3 = string;
        int n = string.indexOf(".", 1);
        if (n < 1) {
            string3 = string3 + "." + string2;
        }
        return string3;
    }

    public static String getPart(String string, int n, boolean bl) {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        ++n;
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!bl && n2 == 0 && Character.isWhitespace(c) || c == '}' && --n2 < 0) break;
            if (c == '{') {
                ++n2;
            }
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String wrap(String string, int n) {
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        StringUtil.addWrappedLine(stringBuffer, stringArray[0], n);
        for (int i = 1; i < stringArray.length; ++i) {
            if (!stringArray[i].trim().equals("")) {
                stringBuffer.append(Globals.NEWLINE);
                stringBuffer.append('\t');
                stringBuffer.append(Globals.NEWLINE);
                stringBuffer.append('\t');
                String string2 = stringArray[i];
                string2 = StringUtil.rtrim(string2);
                StringUtil.addWrappedLine(stringBuffer, string2, n);
                continue;
            }
            stringBuffer.append(Globals.NEWLINE);
            stringBuffer.append('\t');
        }
        return stringBuffer.toString();
    }

    private static void addWrappedLine(StringBuffer stringBuffer, String string, int n) {
        int n2;
        int n3 = stringBuffer.length();
        stringBuffer.append(string);
        while (n3 < stringBuffer.length() && (n2 = stringBuffer.indexOf(" ", n3 + n)) >= 0 && n2 < stringBuffer.length()) {
            stringBuffer.deleteCharAt(n2);
            stringBuffer.insert(n2, Globals.NEWLINE + "\t");
            n3 = n2 + Globals.NEWLINE_LENGTH;
        }
    }

    public static String quoteForHTML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append("&#").append((int)string.charAt(i)).append(";");
        }
        return stringBuilder.toString();
    }

    public static String quote(String string, String string2, char c) {
        return StringUtil.quote(string, string2, c, 0);
    }

    private static String quote(String string, String string2, char c, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            boolean bl;
            char c2 = string.charAt(i);
            boolean bl2 = bl = string2.indexOf(c2) >= 0 || c2 == c;
            if (n > 0 && (++n2 >= n || bl && n2 >= n - 1)) {
                stringBuilder.append(c);
                stringBuilder.append('\n');
                n2 = 0;
            }
            if (bl) {
                stringBuilder.append(c);
                ++n2;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String unquote(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                if (c2 != '\n') {
                    stringBuilder.append(c2);
                }
                bl = false;
                continue;
            }
            if (c2 != c) {
                stringBuilder.append(c2);
                continue;
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static String makeBibtexExtension(String string) {
        if (!string.toLowerCase().endsWith(".bib")) {
            return string + ".bib";
        }
        return string;
    }

    public static String booleanToBinaryString(boolean bl) {
        return bl ? "1" : "0";
    }
}

