/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.CallBack;
import net.sf.jabref.EasyDateFormat;
import net.sf.jabref.EntryMarker;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.Worker;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutHelper;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.ExternalFileTypeEntryEditor;
import net.sf.jabref.external.RegExpFileSearch;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.KeywordGroup;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.util.DOIUtil;
import net.sf.jabref.util.FileNameCleaner;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.MonthUtil;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.UtilFindFiles;
import net.sf.jabref.util.YearUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Util {
    private static final Pattern REMOTE_LINK_PATTERN = Pattern.compile("[a-z]+://.*");
    private static final EasyDateFormat dateFormatter = new EasyDateFormat();
    private static final Log LOGGER = LogFactory.getLog(Util.class);
    private static final Pattern squareBracketsPattern = Pattern.compile("\\[.*?\\]");
    private static final Pattern BRACED_TITLE_CAPITAL_PATTERN = Pattern.compile("\\{[A-Z]+\\}");

    public static void placeDialog(Dialog dialog, Container container) {
        dialog.setLocationRelativeTo(container);
    }

    public static String parseField(String string) {
        if (string.length() == 0) {
            return string;
        }
        String[] stringArray = string.split("#");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if (string3.length() <= 0) continue;
            char c = string3.charAt(0);
            if (c == '{' || c == '\"') {
                stringBuilder.append(StringUtil.shaveString(string2));
                continue;
            }
            String string4 = StringUtil.shaveString(string3);
            if (Util.isInteger(string4)) {
                stringBuilder.append(string4);
                continue;
            }
            stringBuilder.append('#').append(string4).append('#');
        }
        return stringBuilder.toString();
    }

    private static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String getPublicationDate(BibtexEntry bibtexEntry) {
        MonthUtil.Month month;
        String string = bibtexEntry.getField("year");
        if (string == null) {
            return null;
        }
        String string2 = YearUtil.toFourDigitYear(string.toString());
        string = bibtexEntry.getField("month");
        if (string != null && (month = MonthUtil.getMonth(string.toString())).isValid()) {
            return string2 + "-" + month.twoDigitNumber;
        }
        return string2;
    }

    public static String checkLegalKey(String string) {
        if (string == null) {
            return null;
        }
        if (!JabRefPreferences.getInstance().getBoolean("enforceLegalBibtexKey")) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c) || c == '{' || c == '\\' || c == '\"' || c == '}' || c == ',') continue;
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c) || c == '#' || c == '{' || c == '\\' || c == '\"' || c == '}' || c == '~' || c == ',' || c == '^' || c == '\'') continue;
            stringBuilder.append(c);
        }
        return Util.replaceSpecialCharacters(stringBuilder.toString());
    }

    public static String replaceSpecialCharacters(String string) {
        for (Map.Entry<String, String> entry : Globals.UNICODE_CHARS.entrySet()) {
            string = string.replaceAll(entry.getKey(), entry.getValue());
        }
        return string;
    }

    public static TreeSet<String> findDeliminatedWordsInField(BibtexDatabase bibtexDatabase, String string, String string2) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string3 : bibtexDatabase.getKeySet()) {
            BibtexEntry bibtexEntry = bibtexDatabase.getEntryById(string3);
            String string4 = bibtexEntry.getField(string);
            if (string4 == null) continue;
            String string5 = string4.toString().trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string5, string2);
            while (stringTokenizer.hasMoreTokens()) {
                treeSet.add(StringUtil.nCase(stringTokenizer.nextToken().trim()));
            }
        }
        return treeSet;
    }

    public static TreeSet<String> findAllWordsInField(BibtexDatabase bibtexDatabase, String string, String string2) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string3 : bibtexDatabase.getKeySet()) {
            BibtexEntry bibtexEntry = bibtexDatabase.getEntryById(string3);
            String string4 = bibtexEntry.getField(string);
            if (string4 == null) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string4.toString(), string2, false);
            while (stringTokenizer.hasMoreTokens()) {
                treeSet.add(StringUtil.nCase(stringTokenizer.nextToken().trim()));
            }
        }
        return treeSet;
    }

    public static Set<String> findAuthorLastNames(BibtexDatabase bibtexDatabase, List<String> list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : bibtexDatabase.getKeySet()) {
            BibtexEntry bibtexEntry = bibtexDatabase.getEntryById(string);
            for (String string2 : list) {
                String string3 = bibtexEntry.getField(string2);
                if (string3 == null || string3.length() <= 0) continue;
                AuthorList authorList = AuthorList.getAuthorList(string3);
                for (int i = 0; i < authorList.size(); ++i) {
                    AuthorList.Author author = authorList.getAuthor(i);
                    String string4 = author.getLast();
                    if (string4 == null || string4.length() <= 0) continue;
                    treeSet.add(string4);
                }
            }
        }
        return treeSet;
    }

    public static void openExternalViewer(MetaData metaData, String string, String string2) throws IOException {
        block27: {
            String[] stringArray;
            Object object;
            Object object2;
            if (string2.equals("ps") || string2.equals("pdf")) {
                object2 = metaData.getFileDirectory(string2);
                object = FileUtil.expandFilename(string, (String[])object2);
                if (object == null || !((File)object).exists()) {
                    throw new IOException(Globals.lang("File not found") + " (" + string2 + "): '" + string + "'.");
                }
                string = ((File)object).getCanonicalPath();
                stringArray = ((File)object).getName().split("\\.");
                if (stringArray.length >= 2) {
                    if (stringArray[stringArray.length - 1].equalsIgnoreCase("pdf")) {
                        string2 = "pdf";
                    } else if (stringArray[stringArray.length - 1].equalsIgnoreCase("ps") || stringArray.length >= 3 && stringArray[stringArray.length - 2].equalsIgnoreCase("ps")) {
                        string2 = "ps";
                    }
                }
            } else if (string2.equals("doi")) {
                string2 = "url";
            } else if (string2.equals("eprint")) {
                string2 = "url";
                if (!(string = Util.sanitizeUrl(string)).startsWith("http://")) {
                    string = "http://arxiv.org/abs/" + string;
                }
            }
            if (string2.equals("url")) {
                try {
                    Util.openBrowser(string);
                }
                catch (IOException iOException) {
                    System.err.println(Globals.lang("Error_opening_file_'%0'.", string));
                    iOException.printStackTrace();
                }
            } else if (string2.equals("ps")) {
                try {
                    if (Globals.ON_MAC) {
                        object2 = Globals.prefs.getExternalFileTypeByExt("ps");
                        object = object2 != null ? ((ExternalFileType)object2).getOpenWith() : Globals.prefs.get("psviewer");
                        stringArray = new String[]{"/usr/bin/open", "-a", object, string};
                        Runtime.getRuntime().exec(stringArray);
                        break block27;
                    }
                    if (Globals.ON_WIN) {
                        Util.openFileOnWindows(string, true);
                        break block27;
                    }
                    object2 = Globals.prefs.getExternalFileTypeByExt("ps");
                    object = object2 != null ? ((ExternalFileType)object2).getOpenWith() : "xdg-open";
                    stringArray = new String[]{object, string};
                    Runtime.getRuntime().exec(stringArray);
                }
                catch (IOException iOException) {
                    System.err.println("An error occured on the command: " + Globals.prefs.get("psviewer") + " " + string);
                }
            } else if (string2.equals("pdf")) {
                try {
                    if (Globals.ON_MAC) {
                        object2 = Globals.prefs.getExternalFileTypeByExt("pdf");
                        object = object2 != null ? ((ExternalFileType)object2).getOpenWith() : Globals.prefs.get("psviewer");
                        stringArray = new String[]{"/usr/bin/open", "-a", object, string};
                        Runtime.getRuntime().exec(stringArray);
                        break block27;
                    }
                    if (Globals.ON_WIN) {
                        Util.openFileOnWindows(string, true);
                        break block27;
                    }
                    object2 = Globals.prefs.getExternalFileTypeByExt("pdf");
                    object = object2 != null ? ((ExternalFileType)object2).getOpenWith() : Globals.prefs.get("psviewer");
                    stringArray = new String[]{object, string};
                    Runtime.getRuntime().exec(stringArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    System.err.println("An error occured on the command: " + Globals.prefs.get("pdfviewer") + " #" + string);
                    System.err.println(iOException.getMessage());
                }
            } else {
                System.err.println("Message: currently only PDF, PS and HTML files can be opened by double clicking");
            }
        }
    }

    private static void openFileOnWindows(String string, boolean bl) throws IOException {
        string = string.replaceAll("&", "\"&\"").replaceAll(" ", "\" \"");
        String string2 = Globals.osName.startsWith("Windows 9") ? "command.com /c start " + string : "cmd.exe /c start " + string;
        Runtime.getRuntime().exec(string2);
    }

    private static void openFileWithApplicationOnWindows(String string, String string2) throws IOException {
        string = string.replaceAll("&", "\"&\"").replaceAll(" ", "\" \"");
        Runtime.getRuntime().exec(string2 + " " + string);
    }

    public static boolean openExternalFileAnyFormat(MetaData metaData, String string, ExternalFileType externalFileType) throws IOException {
        Object object;
        boolean bl = false;
        if (REMOTE_LINK_PATTERN.matcher(string.toLowerCase()).matches()) {
            bl = true;
        }
        File file = new File(string);
        if (!bl && (object = FileUtil.expandFilename(metaData, string)) != null) {
            file = object;
        }
        if ((bl || file.exists()) && externalFileType != null) {
            object = bl ? string : file.getPath();
            Util.openExternalFilePlatformIndependent(externalFileType, (String)object);
            return true;
        }
        return false;
    }

    private static void openExternalFilePlatformIndependent(ExternalFileType externalFileType, String string) throws IOException {
        if (Globals.ON_MAC) {
            String[] stringArray;
            if (externalFileType.getOpenWith() != null && externalFileType.getOpenWith().length() > 0) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "/usr/bin/open";
                stringArray2[1] = "-a";
                stringArray2[2] = externalFileType.getOpenWith();
                stringArray = stringArray2;
                stringArray2[3] = string;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "/usr/bin/open";
                stringArray = stringArray3;
                stringArray3[1] = string;
            }
            String[] stringArray4 = stringArray;
            Runtime.getRuntime().exec(stringArray4);
        } else if (Globals.ON_WIN) {
            if (externalFileType.getOpenWith() != null && externalFileType.getOpenWith().length() > 0) {
                Util.openFileWithApplicationOnWindows(string, externalFileType.getOpenWith());
            } else {
                Util.openFileOnWindows(string, true);
            }
        } else {
            String[] stringArray = externalFileType.getOpenWith() != null && externalFileType.getOpenWith().length() > 0 ? externalFileType.getOpenWith().split(" ") : new String[]{"xdg-open"};
            String[] stringArray5 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray5, 0, stringArray.length);
            stringArray5[stringArray5.length - 1] = string;
            Runtime.getRuntime().exec(stringArray5);
        }
    }

    public static void openRemoteExternalFile(final MetaData metaData, String string, final ExternalFileType externalFileType) {
        File file = null;
        try {
            file = File.createTempFile("jabref-link", "." + externalFileType.getExtension());
            file.deleteOnExit();
            System.out.println("Downloading to '" + file.getPath() + "'");
            new URLDownload(new URL(string)).downloadToFile(file);
            System.out.println("Done");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        final String string2 = file.getPath();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Util.openExternalFileAnyFormat(metaData, string2, externalFileType);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    public static boolean openExternalFileUnknown(JabRefFrame jabRefFrame, BibtexEntry bibtexEntry, MetaData metaData, String string, UnknownExternalFileType unknownExternalFileType) throws IOException {
        Object object;
        String string2 = Globals.lang("Unable to open file.");
        Object[] objectArray = new String[]{Globals.lang("Define '%0'", unknownExternalFileType.getName()), Globals.lang("Change file type"), Globals.lang("Cancel")};
        String string3 = objectArray[0];
        int n = JOptionPane.showOptionDialog(jabRefFrame, Globals.lang("This external link is of the type '%0', which is undefined. What do you want to do?", unknownExternalFileType.getName()), Globals.lang("Undefined file type"), 1, 3, null, objectArray, string3);
        if (n == 2) {
            jabRefFrame.output(string2);
            return false;
        }
        if (n == 0) {
            ExternalFileType externalFileType = new ExternalFileType(unknownExternalFileType.getName(), "", "", "", "new");
            ExternalFileTypeEntryEditor externalFileTypeEntryEditor = new ExternalFileTypeEntryEditor(jabRefFrame, externalFileType);
            externalFileTypeEntryEditor.setVisible(true);
            if (externalFileTypeEntryEditor.okPressed()) {
                ArrayList<ExternalFileType> arrayList = new ArrayList<ExternalFileType>();
                ExternalFileType[] externalFileTypeArray = Globals.prefs.getExternalFileTypeSelection();
                Collections.addAll(arrayList, externalFileTypeArray);
                arrayList.add(externalFileType);
                Collections.sort(arrayList);
                Globals.prefs.setExternalFileTypes(arrayList);
                return Util.openExternalFileAnyFormat(metaData, string, externalFileType);
            }
            jabRefFrame.output(string2);
            return false;
        }
        FileListTableModel fileListTableModel = new FileListTableModel();
        String string4 = bibtexEntry.getField("file");
        fileListTableModel.setContent(string4);
        FileListEntry fileListEntry = null;
        for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
            object = fileListTableModel.getEntry(i);
            if (!((FileListEntry)object).getLink().equals(string)) continue;
            fileListEntry = object;
            break;
        }
        if (fileListEntry == null) {
            throw new RuntimeException("Could not find the file list entry " + string + " in " + bibtexEntry.toString());
        }
        FileListEntryEditor fileListEntryEditor = new FileListEntryEditor(jabRefFrame, fileListEntry, false, true, metaData);
        fileListEntryEditor.setVisible(true, false);
        if (fileListEntryEditor.okPressed()) {
            object = fileListTableModel.getStringRepresentation();
            UndoableFieldChange undoableFieldChange = new UndoableFieldChange(bibtexEntry, "file", string4, (String)object);
            bibtexEntry.setField("file", (String)object);
            jabRefFrame.basePanel().undoManager.addEdit(undoableFieldChange);
            jabRefFrame.basePanel().markBaseChanged();
            return Util.openExternalFileAnyFormat(metaData, fileListEntry.getLink(), fileListEntry.getType());
        }
        jabRefFrame.output(string2);
        return false;
    }

    public static String sanitizeUrl(String string) {
        if ((string = string.trim()).startsWith("\\url{") && string.endsWith("}")) {
            string = string.substring(5, string.length() - 1);
        }
        if (string.matches("^doi:/*.*")) {
            string = string.replaceFirst("^doi:/*", "");
            string = "http://dx.doi.org/" + string;
        }
        if (DOIUtil.checkForPlainDOI(string) && !string.startsWith("http://")) {
            string = "http://dx.doi.org/" + DOIUtil.getDOI(string);
        }
        string = string.replaceAll("\\+", "%2B");
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            return new URI(null, string, null).toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return string;
        }
    }

    public static ArrayList<String[]> parseMethodsCalls(String string) throws RuntimeException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            String string2;
            int n = i;
            if (!Character.isJavaIdentifierStart(cArray[i])) continue;
            ++i;
            while (i < cArray.length && (Character.isJavaIdentifierPart(cArray[i]) || cArray[i] == '.')) {
                ++i;
            }
            if (i < cArray.length && cArray[i] == '(') {
                string2 = string.substring(n, i);
                if (++i < cArray.length) {
                    int n2;
                    if (cArray[i] == '\"') {
                        n2 = ++i;
                        ++i;
                        boolean bl = false;
                        while (i + 1 < cArray.length && (bl || cArray[i] != '\"' || cArray[i + 1] != ')')) {
                            bl = cArray[i] == '\\' ? !bl : false;
                            ++i;
                        }
                        String string3 = string.substring(n2, i);
                        arrayList.add(new String[]{string2, string3});
                        continue;
                    }
                    n2 = i;
                    while (i < cArray.length && cArray[i] != ')') {
                        ++i;
                    }
                    String string4 = string.substring(n2, i);
                    arrayList.add(new String[]{string2, string4});
                    continue;
                }
                arrayList.add(new String[]{string2});
                continue;
            }
            string2 = string.substring(n, i);
            arrayList.add(new String[]{string2});
        }
        return arrayList;
    }

    public static String expandBrackets(String string, BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        Matcher matcher = squareBracketsPattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = Util.getFieldAndFormat(matcher.group(), bibtexEntry, bibtexDatabase);
            if (string2 == null) {
                string2 = "";
            }
            matcher.appendReplacement(stringBuffer, string2);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static void setAutomaticFields(Collection<BibtexEntry> collection, boolean bl, boolean bl2, boolean bl3) {
        String string = Globals.prefs.get("timeStampField");
        String string2 = Globals.prefs.get("defaultOwner");
        String string3 = dateFormatter.getCurrentDate();
        boolean bl4 = Globals.prefs.getBoolean("useOwner");
        boolean bl5 = Globals.prefs.getBoolean("useTimeStamp");
        if (!(bl4 || bl5 || bl3)) {
            return;
        }
        for (BibtexEntry bibtexEntry : collection) {
            boolean bl6 = bl4 && (bl || bibtexEntry.getField("owner") == null);
            boolean bl7 = bl5 && (bl2 || bibtexEntry.getField(string) == null);
            Util.setAutomaticFields(bibtexEntry, bl6, string2, bl7, string, string3);
            if (!bl3) continue;
            EntryMarker.markEntry(bibtexEntry, 6, false, new NamedCompound(""));
        }
    }

    public static void setAutomaticFields(BibtexEntry bibtexEntry, boolean bl, boolean bl2) {
        String string = Globals.prefs.get("defaultOwner");
        String string2 = dateFormatter.getCurrentDate();
        String string3 = Globals.prefs.get("timeStampField");
        boolean bl3 = Globals.prefs.getBoolean("useOwner") && (bl || bibtexEntry.getField("owner") == null);
        boolean bl4 = Globals.prefs.getBoolean("useTimeStamp") && (bl2 || bibtexEntry.getField(string3) == null);
        Util.setAutomaticFields(bibtexEntry, bl3, string, bl4, string3, string2);
    }

    private static void setAutomaticFields(BibtexEntry bibtexEntry, boolean bl, String string, boolean bl2, String string2, String string3) {
        if (bl) {
            bibtexEntry.setField("owner", string);
        }
        if (bl2) {
            bibtexEntry.setField(string2, string3);
        }
    }

    public static void performCompatibilityUpdate() {
        String string = Globals.prefs.get("generalFields");
        if (string.contains("abstract")) {
            String string2 = string.equals("abstract") ? "" : (string.contains(";abstract;") ? string.replaceAll(";abstract;", ";") : (string.indexOf("abstract;") == 0 ? string.replaceAll("abstract;", "") : (string.indexOf(";abstract") == string.length() - 9 ? string.replaceAll(";abstract", "") : string)));
            Globals.prefs.put("generalFields", string2);
        }
    }

    public static NamedCompound upgradePdfPsToFile(BibtexDatabase bibtexDatabase, String[] stringArray) {
        return Util.upgradePdfPsToFile(bibtexDatabase.getEntryMap().values(), stringArray);
    }

    public static NamedCompound upgradePdfPsToFile(Collection<BibtexEntry> collection, String[] stringArray) {
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Move external links to 'file' field"));
        for (BibtexEntry bibtexEntry : collection) {
            FileListTableModel fileListTableModel = new FileListTableModel();
            String string = bibtexEntry.getField("file");
            if (string != null) {
                fileListTableModel.setContent(string);
            }
            int n = fileListTableModel.getRowCount();
            for (String string2 : stringArray) {
                String string3 = bibtexEntry.getField(string2);
                if (string3 == null || string3.trim().length() <= 0) continue;
                File file = new File(string3);
                FileListEntry fileListEntry = new FileListEntry(file.getName(), string3, Globals.prefs.getExternalFileTypeByExt(string2));
                fileListTableModel.addEntry(fileListTableModel.getRowCount(), fileListEntry);
                bibtexEntry.clearField(string2);
                namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, string2, string3, null));
            }
            if (fileListTableModel.getRowCount() == n) continue;
            String string4 = fileListTableModel.getStringRepresentation();
            bibtexEntry.setField("file", string4);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "file", string, string4));
        }
        namedCompound.end();
        return namedCompound;
    }

    public static boolean warnAssignmentSideEffects(AbstractGroup[] abstractGroupArray, BibtexEntry[] bibtexEntryArray, BibtexDatabase bibtexDatabase, Component component) {
        int n;
        Vector<String> vector = new Vector<String>();
        block0: for (AbstractGroup abstractGroup : abstractGroupArray) {
            KeywordGroup keywordGroup;
            String string;
            if (!(abstractGroup instanceof KeywordGroup) || (string = (keywordGroup = (KeywordGroup)abstractGroup).getSearchField().toLowerCase()).equals("keywords")) continue;
            int n2 = BibtexFields.numberOfPublicFields();
            for (int i = 0; i < n2; ++i) {
                if (!string.equals(BibtexFields.getFieldName(i))) continue;
                vector.add(string);
                continue block0;
            }
        }
        if (vector.size() == 0) {
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer("This action will modify the following field(s)\nin at least one entry each:\n");
        for (n = 0; n < vector.size(); ++n) {
            stringBuffer.append((String)vector.elementAt(n)).append("\n");
        }
        stringBuffer.append("This could cause undesired changes to your entries, so it is\nrecommended that you change the grouping field in your group\ndefinition to \"keywords\" or a non-standard name.\n\nDo you still want to continue?");
        n = JOptionPane.showConfirmDialog(component, stringBuffer, Globals.lang("Warning"), 0, 2);
        return n != 1;
    }

    public static String putBracesAroundCapitals(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                ++n;
            } else if (c == '}') {
                --n;
            } else if (!bl3 && c == '#') {
                boolean bl4 = bl = !bl;
            }
            if (n == 0 && !bl2 && !bl && Character.isLetter(c) && Character.isUpperCase(c)) {
                stringBuilder.append('{');
                bl2 = true;
            }
            if (!(!bl2 || Character.isLetter(c) && Character.isUpperCase(c))) {
                stringBuilder.append('}');
                bl2 = false;
            }
            stringBuilder.append(c);
            bl3 = c == '\\' && !bl3;
        }
        if (bl2) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public static String removeBracesAroundCapitals(String string) {
        String string2 = string;
        while ((string = Util.removeSingleBracesAroundCapitals(string)).length() < string2.length()) {
            string2 = string;
        }
        return string;
    }

    private static String removeSingleBracesAroundCapitals(String string) {
        Matcher matcher = BRACED_TITLE_CAPITAL_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group();
            matcher.appendReplacement(stringBuffer, string2.substring(1, string2.length() - 1));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static OpenFileFilter getFileFilterForField(String string) {
        String string2 = BibtexFields.getFieldExtras(string);
        String string3 = "." + string.toLowerCase();
        OpenFileFilter openFileFilter = "browseDocZip".equals(string2) ? new OpenFileFilter(new String[]{string3, string3 + ".gz", string3 + ".bz2"}) : new OpenFileFilter(new String[]{string3});
        return openFileFilter;
    }

    public static void showQuickErrorDialog(JFrame jFrame, String string, Exception exception) {
        final JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        final CardLayout cardLayout = new CardLayout();
        jPanel.setLayout(cardLayout);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Sans-Serif", 0, 10));
        jTextArea.setEditable(false);
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        jTextArea.setText(stringWriter.toString());
        JLabel jLabel = new JLabel(exception.getMessage());
        JButton jButton = new JButton(Globals.lang("Details"));
        FormLayout formLayout = new FormLayout("left:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Box.createVerticalGlue());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jButton);
        JPanel jPanel3 = defaultFormBuilder.getPanel();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(350, 150));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.show(jPanel, "details");
            }
        });
        jPanel.add((Component)jPanel3, "simple");
        jPanel.add((Component)jPanel2, "details");
        JOptionPane.showMessageDialog(jFrame, jPanel, string, 0);
    }

    public static UndoableEdit massSetField(Collection<BibtexEntry> collection, String string, String string2, boolean bl) {
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Set field"));
        for (BibtexEntry bibtexEntry : collection) {
            String string3 = bibtexEntry.getField(string);
            if (!bl && string3 != null && string3.length() > 0) continue;
            if (string2 != null) {
                bibtexEntry.setField(string, string2);
            } else {
                bibtexEntry.clearField(string);
            }
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, string, string3, string2));
        }
        namedCompound.end();
        return namedCompound;
    }

    public static UndoableEdit massRenameField(Collection<BibtexEntry> collection, String string, String string2, boolean bl) {
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Rename field"));
        for (BibtexEntry bibtexEntry : collection) {
            String string3 = bibtexEntry.getField(string);
            if (string3 == null || string3.length() == 0) continue;
            String string4 = bibtexEntry.getField(string2);
            if (!bl && string4 != null && string4.length() > 0) continue;
            bibtexEntry.setField(string2, string3);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, string2, string4, string3));
            bibtexEntry.clearField(string);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, string, string3, null));
        }
        namedCompound.end();
        return namedCompound;
    }

    public static List<String> findEncodingsForString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < Globals.ENCODINGS.length; ++i) {
            CharsetEncoder charsetEncoder = Charset.forName(Globals.ENCODINGS[i]).newEncoder();
            if (!charsetEncoder.canEncode(string)) continue;
            arrayList.add(Globals.ENCODINGS[i]);
        }
        return arrayList;
    }

    public static int intValueOf(String string) {
        char c;
        int n;
        boolean bl;
        int n2;
        int n3;
        block7: {
            block6: {
                n3 = 0;
                n2 = 0;
                bl = false;
                if (string == null || (n = string.length()) == 0) break block6;
                c = string.charAt(0);
                if (c >= '0' && c <= '9') break block7;
                boolean bl2 = bl = c == '-';
                if (bl2 && ++n2 != n && (c = string.charAt(n2)) >= '0' && c <= '9') break block7;
            }
            throw new NumberFormatException(string);
        }
        while (true) {
            n3 += 48 - c;
            if (++n2 == n) {
                return bl ? n3 : -n3;
            }
            c = string.charAt(n2);
            if (c < '0' || c > '9') {
                throw new NumberFormatException(string);
            }
            n3 *= 10;
        }
    }

    public static String encodeStringArray(String[][] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(Util.encodeStringArray(stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    private static String encodeStringArray(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(Util.encodeString(stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }

    public static String[][] decodeStringDoubleArray(String string) {
        int n;
        ArrayList arrayList = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (!bl && n == 92) {
                bl = true;
                continue;
            }
            if (!bl && n == 58) {
                arrayList2.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
            } else if (!bl && n == 59) {
                arrayList2.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                arrayList.add(arrayList2);
                arrayList2 = new ArrayList();
            } else {
                stringBuilder.append((char)n);
            }
            bl = false;
        }
        if (stringBuilder.length() > 0) {
            arrayList2.add(stringBuilder.toString());
        }
        if (arrayList2.size() > 0) {
            arrayList.add(arrayList2);
        }
        String[][] stringArray = new String[arrayList.size()][];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = new String[((ArrayList)arrayList.get(n)).size()];
            for (int i = 0; i < stringArray[n].length; ++i) {
                stringArray[n][i] = (String)((ArrayList)arrayList.get(n)).get(i);
            }
        }
        return stringArray;
    }

    public static String encodeString(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ';' || c == ':' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static void runAbstractWorker(AbstractWorker abstractWorker) throws Throwable {
        Worker worker = abstractWorker.getWorker();
        CallBack callBack = abstractWorker.getCallBack();
        abstractWorker.init();
        worker.run();
        callBack.update();
    }

    public static String[] getRemainder(String[] stringArray, String[] stringArray2) {
        if (stringArray2.length == 0) {
            return stringArray;
        }
        if (stringArray.equals(stringArray2)) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            boolean bl = false;
            for (String string2 : stringArray2) {
                if (!string2.equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] arrayConcat(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        int n2 = stringArray2.length;
        String[] stringArray3 = new String[n + n2];
        System.arraycopy(stringArray, 0, stringArray3, 0, n);
        System.arraycopy(stringArray2, 0, stringArray3, n, n2);
        return stringArray3;
    }

    public static String getLinkedFileName(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry) {
        String string = bibtexEntry.getCiteKey() == null ? "default" : bibtexEntry.getCiteKey();
        StringReader stringReader = new StringReader(Globals.prefs.get("importFileNamePattern"));
        Layout layout = null;
        try {
            layout = new LayoutHelper(stringReader).getLayoutFromText("net.sf.jabref.export.layout.format.");
        }
        catch (Exception exception) {
            LOGGER.info(Globals.lang("Wrong Format").concat(" ").concat(exception.toString()), exception);
        }
        if (layout != null) {
            string = layout.doLayout(bibtexEntry, bibtexDatabase);
        }
        string = FileNameCleaner.cleanFileName(string);
        return string;
    }

    public static ArrayList<String> getSeparatedKeywords(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";,\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static ArrayList<String> getSeparatedKeywords(BibtexEntry bibtexEntry) {
        return Util.getSeparatedKeywords(bibtexEntry.getField("keywords"));
    }

    public static void putKeywords(BibtexEntry bibtexEntry, ArrayList<String> arrayList, NamedCompound namedCompound) {
        String string;
        String string2 = bibtexEntry.getField("keywords");
        if (arrayList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : arrayList) {
                stringBuilder.append(string3);
                stringBuilder.append(", ");
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            string = stringBuilder.toString();
        } else {
            string = null;
        }
        if (string2 == null && string == null) {
            return;
        }
        if (string2 == null || !string2.equals(string)) {
            bibtexEntry.setField("keywords", string);
            if (namedCompound != null) {
                namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "keywords", string2, string));
            }
        }
    }

    public static void updateField(BibtexEntry bibtexEntry, String string, String string2, NamedCompound namedCompound) {
        Util.updateField(bibtexEntry, string, string2, namedCompound, false);
    }

    public static void updateField(BibtexEntry bibtexEntry, String string, String string2, NamedCompound namedCompound, Boolean bl) {
        String string3 = bibtexEntry.getField(string);
        if (bl.booleanValue() && string3 != null && string3.equals(string2)) {
            string2 = null;
        }
        if (string3 == null && string2 == null) {
            return;
        }
        if (string3 == null || !string3.equals(string2)) {
            bibtexEntry.setField(string, string2);
            if (namedCompound != null) {
                namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, string, string3, string2));
            }
        }
    }

    public static void bindCloseDialogKeyToCancelAction(JRootPane jRootPane, Action action) {
        InputMap inputMap = jRootPane.getInputMap(2);
        ActionMap actionMap = jRootPane.getActionMap();
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", action);
    }

    public static String getResults(URLConnection uRLConnection) throws IOException {
        return Util.getResultsWithEncoding(uRLConnection, null);
    }

    public static String getResultsWithEncoding(URLConnection uRLConnection, String string) throws IOException {
        int n;
        InputStreamReader inputStreamReader = string != null ? new InputStreamReader(uRLConnection.getInputStream(), string) : new InputStreamReader(uRLConnection.getInputStream());
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStreamReader.read()) != -1) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public static boolean updateTimeStampIsSet() {
        return Globals.prefs.getBoolean("useTimeStamp") && Globals.prefs.getBoolean("updateTimestamp");
    }

    public static NamedCompound doUpdateTimeStamp(BibtexEntry bibtexEntry, AbstractUndoableEdit abstractUndoableEdit) {
        NamedCompound namedCompound = new NamedCompound(abstractUndoableEdit.getPresentationName());
        namedCompound.addEdit(abstractUndoableEdit);
        String string = Globals.prefs.get("timeStampField");
        String string2 = dateFormatter.getCurrentDate();
        Util.updateField(bibtexEntry, string, string2, namedCompound);
        return namedCompound;
    }

    public static Runnable autoSetLinks(final Collection<BibtexEntry> collection, final NamedCompound namedCompound, final Set<BibtexEntry> set, final FileListTableModel fileListTableModel, final MetaData metaData, final ActionListener actionListener, final JDialog jDialog) {
        Object object;
        final ExternalFileType[] externalFileTypeArray = Globals.prefs.getExternalFileTypeSelection();
        if (jDialog != null) {
            object = new JProgressBar(0, 0, externalFileTypeArray.length - 1);
            JLabel jLabel = new JLabel(Globals.lang("Searching for files"));
            ((JProgressBar)object).setIndeterminate(true);
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jDialog.setTitle(Globals.lang("Autosetting links"));
            jDialog.getContentPane().add((Component)object, "Center");
            jDialog.getContentPane().add((Component)jLabel, "South");
            jDialog.pack();
            jDialog.setLocationRelativeTo(jDialog.getParent());
        }
        object = new Runnable(){

            @Override
            public void run() {
                Object object;
                ArrayList<File> arrayList = new ArrayList<File>();
                String[] stringArray = metaData.getFileDirectory("file");
                for (String string : stringArray) {
                    arrayList.add(new File(string));
                }
                ArrayList arrayList2 = new ArrayList();
                for (ExternalFileType object2 : externalFileTypeArray) {
                    arrayList2.add(object2.getExtension());
                }
                if (Globals.prefs.getBoolean("useRegExpSearch")) {
                    String string = Globals.prefs.get("regExpSearchExpression");
                    object = RegExpFileSearch.findFilesForSet(collection, arrayList2, arrayList, string);
                } else {
                    object = Util.findAssociatedFiles(collection, arrayList2, arrayList);
                }
                boolean bl = false;
                for (BibtexEntry bibtexEntry : object.keySet()) {
                    FileListTableModel fileListTableModel2;
                    String string = bibtexEntry.getField("file");
                    if (fileListTableModel == null) {
                        fileListTableModel2 = new FileListTableModel();
                        if (string != null) {
                            fileListTableModel2.setContent(string);
                        }
                    } else {
                        assert (collection.size() == 1);
                        fileListTableModel2 = fileListTableModel;
                    }
                    List list = (List)object.get(bibtexEntry);
                    for (File file : list) {
                        file = FileUtil.shortenFileName(file, stringArray);
                        boolean bl2 = false;
                        for (int i = 0; i < fileListTableModel2.getRowCount(); ++i) {
                            FileListEntry fileListEntry = fileListTableModel2.getEntry(i);
                            if (!new File(fileListEntry.getLink()).equals(file)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                        bl = true;
                        int n = file.getPath().lastIndexOf(46);
                        ExternalFileType externalFileType = n >= 0 && n < file.getPath().length() - 1 ? Globals.prefs.getExternalFileTypeByExt(file.getPath().substring(n + 1).toLowerCase()) : new UnknownExternalFileType("");
                        FileListEntry fileListEntry = new FileListEntry(file.getName(), file.getPath(), externalFileType);
                        fileListTableModel2.addEntry(fileListTableModel2.getRowCount(), fileListEntry);
                        String string2 = fileListTableModel2.getStringRepresentation();
                        if (string2.length() == 0) {
                            string2 = null;
                        }
                        if (namedCompound != null) {
                            UndoableFieldChange undoableFieldChange = new UndoableFieldChange(bibtexEntry, "file", string, string2);
                            namedCompound.addEdit(undoableFieldChange);
                        }
                        if (fileListTableModel == null) {
                            bibtexEntry.setField("file", string2);
                        }
                        if (set == null) continue;
                        set.add(bibtexEntry);
                    }
                }
                final int n = bl ? 1 : 0;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (jDialog != null) {
                            jDialog.dispose();
                        }
                        if (actionListener != null) {
                            actionListener.actionPerformed(new ActionEvent(this, n, ""));
                        }
                    }
                });
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jDialog != null) {
                    jDialog.setVisible(true);
                }
            }
        });
        return object;
    }

    public static Runnable autoSetLinks(BibtexEntry bibtexEntry, FileListTableModel fileListTableModel, MetaData metaData, ActionListener actionListener, JDialog jDialog) {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        arrayList.add(bibtexEntry);
        return Util.autoSetLinks(arrayList, null, null, fileListTableModel, metaData, actionListener, jDialog);
    }

    public static void openFolderAndSelectFile(String string) throws IOException {
        if (Globals.ON_WIN) {
            Util.openFolderAndSelectFileOnWindows(string);
        } else if (Globals.ON_LINUX) {
            Util.openFolderAndSelectFileOnLinux(string);
        } else {
            Util.openFolderAndSelectFileGeneric(string);
        }
    }

    private static void openFolderAndSelectFileOnLinux(String string) throws IOException {
        String string2 = System.getenv("DESKTOP_SESSION").toLowerCase();
        String string3 = string2.contains("gnome") ? "nautilus " + string : (string2.contains("kde") ? "dolphin --select " + string : "xdg-open " + string.substring(0, string.lastIndexOf(File.separator)));
        Runtime.getRuntime().exec(string3);
    }

    private static void openFolderAndSelectFileGeneric(String string) throws IOException {
        File file = new File(string);
        Desktop.getDesktop().open(file.getParentFile());
    }

    private static void openFolderAndSelectFileOnWindows(String string) throws IOException {
        string = string.replace("&", "\"&\"");
        String string2 = "explorer.exe /select,\"" + string + "\"";
        Runtime.getRuntime().exec(string2);
    }

    public static List<File> getListOfLinkedFiles(BibtexEntry[] bibtexEntryArray, String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (BibtexEntry bibtexEntry : bibtexEntryArray) {
            FileListTableModel fileListTableModel = new FileListTableModel();
            fileListTableModel.setContent(bibtexEntry.getField("file"));
            for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
                FileListEntry fileListEntry = fileListTableModel.getEntry(i);
                File file = FileUtil.expandFilename(fileListEntry.getLink(), stringArray);
                if (file == null) continue;
                arrayList.add(file);
            }
        }
        return arrayList;
    }

    public static Map<BibtexEntry, List<File>> findAssociatedFiles(Collection<BibtexEntry> collection, Collection<String> collection2, Collection<File> collection3) {
        HashMap<BibtexEntry, List<File>> hashMap = new HashMap<BibtexEntry, List<File>>();
        Set<File> set = UtilFindFiles.findFiles(collection2, collection3);
        for (BibtexEntry object : collection) {
            hashMap.put(object, new ArrayList());
        }
        boolean bl = Globals.prefs.getBoolean("autolinkExactKeyOnly");
        block1: for (File file : set) {
            String string;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            for (BibtexEntry bibtexEntry : collection) {
                string = bibtexEntry.getCiteKey();
                if (string == null || string.length() <= 0 || n <= 0 || !string2.substring(0, n).equals(string)) continue;
                hashMap.get(bibtexEntry).add(file);
                continue block1;
            }
            if (bl) continue;
            for (BibtexEntry bibtexEntry : collection) {
                string = bibtexEntry.getCiteKey();
                if (string == null || string.length() <= 0 || !string2.startsWith(string)) continue;
                hashMap.get(bibtexEntry).add(file);
                continue block1;
            }
        }
        return hashMap;
    }

    public static String getFieldAndFormat(String string, BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        String string2;
        String string3;
        int n = (string = StringUtil.stripBrackets(string)).indexOf(58);
        if (n == -1) {
            string3 = string;
            string2 = null;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        string3 = string3.trim();
        if (string3.length() == 0) {
            return null;
        }
        String string4 = BibtexDatabase.getResolvedField(string3, bibtexEntry, bibtexDatabase);
        if (string4 == null) {
            string4 = LabelPatternUtil.makeLabel(bibtexEntry, string3);
        }
        if (string4 == null) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return string4;
        }
        String[] stringArray = string2.split(":");
        string4 = LabelPatternUtil.applyModifiers(string4, stringArray, 0);
        return string4;
    }

    public static void openBrowser(String string) throws IOException {
        string = Util.sanitizeUrl(string);
        ExternalFileType externalFileType = Globals.prefs.getExternalFileTypeByExt("html");
        Util.openExternalFilePlatformIndependent(externalFileType, string);
    }
}

