/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRefPreferences;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMPSchemaBibtex
extends XMPSchema {
    public static final String NAMESPACE = "http://jabref.sourceforge.net/bibteXMP/";
    private static final String KEY = "bibtex";
    private static final HashSet<String> preserveWhiteSpace = new HashSet();

    public XMPSchemaBibtex(XMPMetadata xMPMetadata) {
        super(xMPMetadata, KEY, NAMESPACE);
    }

    public XMPSchemaBibtex(Element element, String string) {
        super(element, KEY);
    }

    private String makeProperty(String string) {
        return "bibtex:" + string;
    }

    public List<String> getPersonList(String string) {
        return this.getSequenceList(string);
    }

    public void setPersonList(String string, String string2) {
        AuthorList authorList = AuthorList.getAuthorList(string2);
        int n = authorList.size();
        for (int i = 0; i < n; ++i) {
            this.addSequenceValue(string, authorList.getAuthor(i).getFirstLast(false));
        }
    }

    @Override
    public String getTextProperty(String string) {
        return super.getTextProperty(this.makeProperty(string));
    }

    @Override
    public void setTextProperty(String string, String string2) {
        super.setTextProperty(this.makeProperty(string), string2);
    }

    @Override
    public List<String> getBagList(String string) {
        return super.getBagList(this.makeProperty(string));
    }

    @Override
    public void removeBagValue(String string, String string2) {
        super.removeBagValue(this.makeProperty(string), string2);
    }

    @Override
    public void addBagValue(String string, String string2) {
        super.addBagValue(this.makeProperty(string), string2);
    }

    @Override
    public List<String> getSequenceList(String string) {
        return super.getSequenceList(this.makeProperty(string));
    }

    @Override
    public void removeSequenceValue(String string, String string2) {
        super.removeSequenceValue(this.makeProperty(string), string2);
    }

    @Override
    public void addSequenceValue(String string, String string2) {
        super.addSequenceValue(this.makeProperty(string), string2);
    }

    @Override
    public List<Calendar> getSequenceDateList(String string) throws IOException {
        return super.getSequenceDateList(this.makeProperty(string));
    }

    @Override
    public void removeSequenceDateValue(String string, Calendar calendar) {
        super.removeSequenceDateValue(this.makeProperty(string), calendar);
    }

    @Override
    public void addSequenceDateValue(String string, Calendar calendar) {
        super.addSequenceDateValue(this.makeProperty(string), calendar);
    }

    private static String getContents(NodeList nodeList) {
        Element element = (Element)nodeList.item(0);
        StringBuffer stringBuffer = null;
        NodeList nodeList2 = element.getElementsByTagName("rdf:li");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Element element2 = (Element)nodeList2.item(i);
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(" and ");
            }
            stringBuffer.append(XMPSchemaBibtex.getTextContent(element2));
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return null;
    }

    public static Map<String, String> getAllProperties(XMPSchema xMPSchema, String string) {
        Object object;
        Object object2;
        NodeList nodeList = xMPSchema.getElement().getChildNodes();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (nodeList == null) {
            return hashMap;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string2;
            String[] object32;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 2 && node.getNodeType() != 1 || (object32 = (string2 = node.getNodeName()).split(":")).length != 2 || !object32[0].equals(string)) continue;
            object2 = ((Element)node).getElementsByTagName("rdf:Seq");
            if (object2.getLength() > 0) {
                object = XMPSchemaBibtex.getContents((NodeList)object2);
                if (object == null) continue;
                hashMap.put(object32[1], (String)object);
                continue;
            }
            object = ((Element)node).getElementsByTagName("rdf:Bag");
            if (object.getLength() > 0) {
                String string3 = XMPSchemaBibtex.getContents((NodeList)object);
                if (string3 == null) continue;
                hashMap.put(object32[1], string3);
                continue;
            }
            hashMap.put(object32[1], XMPSchemaBibtex.getTextContent(node));
        }
        NamedNodeMap namedNodeMap = xMPSchema.getElement().getAttributes();
        int n2 = namedNodeMap.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node = namedNodeMap.item(i);
            object2 = node.getNodeName();
            object = ((String)object2).split(":");
            if (((String[])object).length != 2 || !object[0].equals(string)) continue;
            hashMap.put(object[1], node.getNodeValue());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (String)entry.getKey();
            if (preserveWhiteSpace.contains(object2)) continue;
            entry.setValue(((String)entry.getValue()).replaceAll("\\s+", " ").trim());
        }
        return hashMap;
    }

    public void setBibtexEntry(BibtexEntry bibtexEntry) {
        this.setBibtexEntry(bibtexEntry, null);
    }

    public void setBibtexEntry(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        Set<String> set = bibtexEntry.getAllFields();
        JabRefPreferences jabRefPreferences = JabRefPreferences.getInstance();
        if (jabRefPreferences.getBoolean("useXmpPrivacyFilter")) {
            TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(jabRefPreferences.getStringArray("xmpPrivacyFilters")));
            set.removeAll(treeSet);
        }
        for (String string : set) {
            String string2 = BibtexDatabase.getResolvedField(string, bibtexEntry, bibtexDatabase);
            if (string.equals("author") || string.equals("editor")) {
                this.setPersonList(string, string2);
                continue;
            }
            this.setTextProperty(string, string2);
        }
        this.setTextProperty("entrytype", bibtexEntry.getType().getName());
    }

    public BibtexEntry getBibtexEntry() {
        String string = this.getTextProperty("entrytype");
        BibtexEntryType bibtexEntryType = string != null ? BibtexEntryType.getStandardType(string) : BibtexEntryTypes.OTHER;
        BibtexEntry bibtexEntry = new BibtexEntry(IdGenerator.next(), bibtexEntryType);
        Map<String, String> map = XMPSchemaBibtex.getAllProperties(this, KEY);
        map.remove("entrytype");
        bibtexEntry.setField(map);
        return bibtexEntry;
    }

    public static String getTextContent(Node node) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3) continue;
            stringBuilder.append(node2.getNodeValue());
            bl = true;
        }
        return bl ? stringBuilder.toString() : "";
    }

    static {
        preserveWhiteSpace.add("abstract");
        preserveWhiteSpace.add("note");
        preserveWhiteSpace.add("review");
    }
}

