/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.auximport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexString;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.KeyCollisionException;

public class AuxSubGenerator {
    private final HashSet<String> mySet = new HashSet(20);
    private final Vector<String> notFoundList = new Vector();
    private BibtexDatabase db;
    private BibtexDatabase auxDB;
    private int nestedAuxCounter;
    private int crossreferencedEntriesCount = 0;

    public AuxSubGenerator(BibtexDatabase bibtexDatabase) {
        this.db = bibtexDatabase;
    }

    private void setReferenceDatabase(BibtexDatabase bibtexDatabase) {
        this.db = bibtexDatabase;
    }

    private boolean parseAuxFile(String string) {
        boolean bl = true;
        Pattern pattern = Pattern.compile("\\\\citation\\{.+\\}");
        BufferedReader bufferedReader = null;
        Vector<String> vector = new Vector<String>(5);
        vector.add(string);
        File file = new File(string);
        String string2 = file.getParent();
        string2 = string2 != null ? string2 + File.separator : "";
        this.nestedAuxCounter = -1;
        for (int i = 0; i < vector.size(); ++i) {
            boolean bl2;
            boolean bl3;
            String string3 = (String)vector.elementAt(i);
            try {
                bufferedReader = new BufferedReader(new FileReader(string3));
                bl3 = true;
                bl2 = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Cannot locate input file! " + fileNotFoundException.getMessage());
                bl = false;
                bl3 = false;
                bl2 = false;
            }
            while (bl3) {
                String string4;
                try {
                    string4 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    string4 = null;
                    bl3 = false;
                }
                if (string4 != null) {
                    String string5;
                    int n;
                    int n2;
                    Matcher matcher = pattern.matcher(string4);
                    while (matcher.find()) {
                        String string6;
                        String[] stringArray;
                        int n3 = matcher.end() - matcher.start();
                        if (n3 <= 11 || (stringArray = (string6 = matcher.group().substring(matcher.start() + 10, matcher.end() - 1)).split(",")) == null) continue;
                        int n4 = stringArray.length;
                        for (String string7 : stringArray) {
                            if (string7 == null) continue;
                            this.mySet.add(string7.trim());
                        }
                    }
                    int n5 = string4.indexOf("\\@input{");
                    if (n5 < 0 || (n2 = string4.indexOf("}", n = n5 + 8)) <= n || vector.contains(string5 = string2 + string4.substring(n5 + 8, n2))) continue;
                    vector.add(string5);
                    continue;
                }
                bl3 = false;
            }
            if (!bl2) continue;
            try {
                bufferedReader.close();
                ++this.nestedAuxCounter;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    private void resolveTags() {
        Object object;
        Object object2;
        this.auxDB = new BibtexDatabase();
        this.notFoundList.clear();
        for (String object3 : this.mySet) {
            object2 = this.db.getEntryByKey(object3);
            if (object2 == null) {
                this.notFoundList.add(object3);
                continue;
            }
            this.insertEntry(this.auxDB, (BibtexEntry)object2);
            object = ((BibtexEntry)object2).getField("crossref");
            if (object == null || this.mySet.contains(object)) continue;
            BibtexEntry bibtexEntry = this.db.getEntryByKey((String)object);
            if (bibtexEntry == null) {
                this.notFoundList.add((String)object);
                continue;
            }
            this.insertEntry(this.auxDB, bibtexEntry);
            ++this.crossreferencedEntriesCount;
        }
        if (this.auxDB.getEntryCount() > 0) {
            this.auxDB.setPreamble(this.db.getPreamble());
            Set<String> set = this.db.getStringKeySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = this.db.getString((String)object2);
                this.auxDB.addString((BibtexString)object);
            }
        }
    }

    private void insertEntry(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry) {
        try {
            BibtexEntry bibtexEntry2 = (BibtexEntry)bibtexEntry.clone();
            bibtexEntry2.setId(IdGenerator.next());
            bibtexDatabase.insertEntry(bibtexEntry2);
        }
        catch (KeyCollisionException keyCollisionException) {
            keyCollisionException.printStackTrace();
        }
    }

    public final Vector<String> generate(String string, BibtexDatabase bibtexDatabase) {
        this.setReferenceDatabase(bibtexDatabase);
        this.parseAuxFile(string);
        this.resolveTags();
        return this.notFoundList;
    }

    public BibtexDatabase getGeneratedDatabase() {
        if (this.auxDB == null) {
            this.auxDB = new BibtexDatabase();
        }
        return this.auxDB;
    }

    public final int getFoundKeysInAux() {
        return this.mySet.size();
    }

    public final int getResolvedKeysCount() {
        return this.auxDB.getEntryCount() - this.crossreferencedEntriesCount;
    }

    public final int getNotResolvedKeysCount() {
        return this.notFoundList.size();
    }

    public final int getCrossreferencedEntriesCount() {
        return this.crossreferencedEntriesCount;
    }

    public final void clear() {
        this.mySet.clear();
        this.notFoundList.clear();
        this.crossreferencedEntriesCount = 0;
    }

    public Vector<String> getNotFoundList() {
        return this.notFoundList;
    }

    public int getNestedAuxCounter() {
        return this.nestedAuxCounter;
    }
}

