/*
 * Decompiled with CFR 0.152.
 */
package spl;

import java.util.List;
import org.sciplore.beans.Abstract;
import org.sciplore.beans.Author;
import org.sciplore.beans.Document;
import org.sciplore.formatter.Bean;
import org.sciplore.formatter.SimpleTypeElementBean;
import spl.DocumentsWrapper;

class DocumentWrapper {
    private Document xmlDocument;

    public DocumentWrapper(Document document) {
        this.xmlDocument = document;
    }

    public Document getXmlDocument() {
        return this.xmlDocument;
    }

    public void setXmlDocument(Document document) {
        this.xmlDocument = document;
    }

    public String getTitle() {
        if (this.hasTitle()) {
            return this.xmlDocument.getTitle().getValue();
        }
        return "";
    }

    private boolean hasTitle() {
        return this.xmlDocument.getTitle() != null && this.xmlDocument.getTitle().getValue() != null && !this.xmlDocument.getTitle().getValue().isEmpty();
    }

    public String getAbstract() {
        if (this.hasAbstract()) {
            return ((Abstract)this.xmlDocument.getAbstract()).getValue();
        }
        return "";
    }

    private boolean hasAbstract() {
        return this.xmlDocument.getAbstract() != null && ((Abstract)this.xmlDocument.getAbstract()).getValue() != null && !((Abstract)this.xmlDocument.getAbstract()).getValue().isEmpty();
    }

    public String getAuthors(String string) {
        if (this.hasAuthors()) {
            List<Bean> list = this.xmlDocument.getAuthors().getCollection();
            list = DocumentsWrapper.sortAuthors(list);
            String string2 = "";
            int n = 1;
            for (Bean bean : list) {
                if (n < list.size()) {
                    string2 = string2 + this.getNameComplete((Author)bean);
                    string2 = string2 + ' ' + string + ' ';
                } else {
                    string2 = string2 + this.getNameComplete((Author)bean);
                }
                ++n;
            }
            return string2;
        }
        return "";
    }

    private boolean hasAuthors() {
        return this.xmlDocument.getAuthors() != null && this.xmlDocument.getAuthors().getCollection() != null && !this.xmlDocument.getAuthors().getCollection().isEmpty();
    }

    public String getDoi() {
        if (this.hasDoi()) {
            return this.getSimpleTypeValue(this.xmlDocument.getDoi());
        }
        return "";
    }

    private boolean hasDoi() {
        return this.xmlDocument.getDoi() != null && this.getSimpleTypeValue(this.xmlDocument.getDoi()) != null && !this.getSimpleTypeValue(this.xmlDocument.getDoi()).isEmpty();
    }

    public String getYear() {
        if (this.hasYear()) {
            return this.getSimpleTypeValue(this.xmlDocument.getYear());
        }
        return "";
    }

    private boolean hasYear() {
        return this.getSimpleTypeValue(this.xmlDocument.getYear()) != null && !this.getSimpleTypeValue(this.xmlDocument.getYear()).isEmpty() && !this.getSimpleTypeValue(this.xmlDocument.getYear()).equalsIgnoreCase("null");
    }

    private String getNameComplete(Author author) {
        if (author == null) {
            return "";
        }
        String string = "";
        if (this.getSimpleTypeValue(author.getName_First()) != null) {
            string = string + this.getSimpleTypeValue(author.getName_First()).trim() + ' ';
        }
        if (this.getSimpleTypeValue(author.getName_Middle()) != null) {
            string = string + this.getSimpleTypeValue(author.getName_Middle()).trim() + ' ';
        }
        if (this.getSimpleTypeValue(author.getName_Last_Prefix()) != null) {
            string = string + this.getSimpleTypeValue(author.getName_Last_Prefix()).trim() + ' ';
        }
        if (this.getSimpleTypeValue(author.getName_Last()) != null) {
            string = string + this.getSimpleTypeValue(author.getName_Last()).trim() + ' ';
        }
        if (this.getSimpleTypeValue(author.getName_Last_Suffix()) != null) {
            string = string + this.getSimpleTypeValue(author.getName_Last_Suffix()).trim() + ' ';
        }
        return string.trim();
    }

    private String getSimpleTypeValue(Bean bean) {
        if (!(bean instanceof SimpleTypeElementBean)) {
            return null;
        }
        SimpleTypeElementBean simpleTypeElementBean = (SimpleTypeElementBean)bean;
        if (simpleTypeElementBean.getValue() == null || simpleTypeElementBean.getValue().equalsIgnoreCase("null") || simpleTypeElementBean.getValue().length() <= 0) {
            return null;
        }
        return simpleTypeElementBean.getValue();
    }
}

