/*
 * Decompiled with CFR 0.152.
 */
package spl;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.GZIPOutputStream;

class Tools {
    public static final int WEBSERVICE_APP_ID = 9;
    public static String WEBSERVICE_VERSION_SHORT = "0.1";

    Tools() {
    }

    public static byte[] zip(File file) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) > 0) {
                gZIPOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            gZIPOutputStream.finish();
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getStackTraceAsString(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print(" [ ");
        printWriter.print(exception.getClass().getName());
        printWriter.print(" ] ");
        printWriter.print(exception.getMessage());
        exception.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static void centerRelativeToWindow(Dialog dialog, Container container) {
        Point point = container.getLocationOnScreen();
        Dimension dimension = container.getSize();
        Dimension dimension2 = dialog.getSize();
        int n = dimension.width > dimension2.width ? (dimension.width - dimension2.width) / 2 + point.x : point.x;
        int n2 = dimension.height > dimension2.height ? (dimension.height - dimension2.height) / 2 + point.y : point.y;
        dialog.setLocation(n, n2);
    }

    public static String getLink(String string, URL uRL) {
        block8: {
            if (string == null || string.isEmpty()) {
                return null;
            }
            if (!Tools.isAbsolutePath(string)) {
                try {
                    if (string.startsWith("\\\\")) {
                        string = string.replace("\\\\", "file://");
                        string = string.replace('\\', '/').replaceAll(" ", "%20");
                        URL uRL2 = new URL(string);
                        File file = new File(uRL2.toURI());
                        return file.getPath();
                    }
                    if (uRL != null) {
                        URL uRL3 = new URL(uRL, string);
                        File file = new File(uRL3.toURI());
                        return file.getPath();
                    }
                    break block8;
                }
                catch (MalformedURLException malformedURLException) {
                    return string;
                }
                catch (URISyntaxException uRISyntaxException) {
                    return string;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return string;
                }
            }
            return string;
        }
        return string;
    }

    private static boolean isAbsolutePath(String string) {
        String string2 = System.getProperty("os.name").substring(0, 3);
        String string3 = System.getProperty("file.separator");
        if (string2.equals("Win")) {
            return string.length() > 1 && string.substring(1, 2).equals(":") || string.startsWith(string3) && !string.startsWith("\\\\");
        }
        if (string2.equals("Mac")) {
            return string.startsWith(string3);
        }
        return string.startsWith(string3);
    }
}

