/*
 * Decompiled with CFR 0.152.
 */
package com.jmupdf;

import com.jmupdf.JmuPdf;
import com.jmupdf.Page;
import com.jmupdf.exceptions.DocException;
import com.jmupdf.interfaces.DocumentTypes;
import com.jmupdf.interfaces.ImageTypes;
import com.jmupdf.interfaces.TifTypes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class Document
extends JmuPdf
implements DocumentTypes,
ImageTypes,
TifTypes {
    private String document;
    private String password;
    private long handle;
    private int pageCount;
    private int type;
    private boolean isCached;

    public void open(String document, String password, int type) throws DocException {
        this.document = document;
        this.password = password;
        this.type = type;
        this.handle = 0L;
        this.pageCount = 0;
        this.isCached = false;
        File file = new File(document);
        if (!file.exists()) {
            throw new DocException("Document " + document + " does not exist.");
        }
        if (type == 0) {
            this.handle = Document.muPdfOpen(document, password);
        } else if (type == 1) {
            this.handle = Document.muXpsOpen(document);
        }
        if (this.handle > 0L) {
            this.pageCount = Document.getPageCount(this.handle);
        }
    }

    public void open(byte[] document, String password, int type) throws DocException {
        try {
            File tmp = File.createTempFile("jmupdf" + this.getClass().hashCode(), ".tmp");
            tmp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tmp.getAbsolutePath(), true);
            fos.write(document, 0, document.length);
            fos.flush();
            fos.close();
            this.open(tmp.getAbsolutePath(), password, type);
            this.isCached = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.handle > 0L) {
            File file;
            if (this.getType() == 0) {
                Document.muPdfClose(this.handle);
            } else if (this.getType() == 1) {
                Document.muXpsClose(this.handle);
            }
            if (this.isCached && (file = new File(this.document)).exists()) {
                file.delete();
            }
            this.handle = 0L;
        }
    }

    public long getHandle() {
        return this.handle;
    }

    public int getType() {
        return this.type;
    }

    public int getPageCount() {
        if (this.handle > 0L) {
            return this.pageCount;
        }
        return 0;
    }

    public String getDocumentName() {
        if (this.handle > 0L) {
            return this.document;
        }
        return null;
    }

    public String getPassWord() {
        return this.password;
    }

    public Page getPage(int page) {
        if (this.handle > 0L) {
            return new Page(this, page);
        }
        return null;
    }

    public boolean saveAsPng(int page, String file, float zoom, int saveAlpha, int color) {
        if (!(this.handle <= 0L || color != 1 && color != 10 || saveAlpha != 1 && saveAlpha != 0)) {
            return Document.writePng(this.handle, page, zoom, saveAlpha, color, file) == 0;
        }
        return false;
    }

    public boolean saveAsPnm(int page, String file, float zoom, int color) {
        if (this.handle > 0L && (color == 1 || color == 10)) {
            return Document.writePnm(this.handle, page, zoom, color, file) == 0;
        }
        return false;
    }

    public boolean saveAsPam(int page, String file, float zoom, int saveAlpha, int color) {
        if (!(this.handle <= 0L || color != 1 && color != 10 || saveAlpha != 1 && saveAlpha != 0)) {
            return Document.writePam(this.handle, page, zoom, saveAlpha, color, file) == 0;
        }
        return false;
    }

    public boolean saveAsPbm(int page, String file, float zoom) {
        if (this.handle > 0L) {
            return Document.writePbm(this.handle, page, zoom, file) == 0;
        }
        return false;
    }

    public boolean saveAsJPeg(int page, String file, float zoom, int color, int quality) {
        if (this.handle > 0L && (color == 1 || color == 10)) {
            if (quality < 0 || quality > 100) {
                quality = 75;
            }
            return Document.writeJPeg(this.handle, page, zoom, color, file, quality) == 0;
        }
        return false;
    }

    public boolean saveAsTif(int page, String file, float zoom, int saveAlpha, int color, int compression, int mode, int quality) {
        if (this.handle > 0L) {
            if (color != 1 && color != 10 && color != 12 && color != 121) {
                this.log("Invalid color type specified.");
                return false;
            }
            if (saveAlpha != 1 && saveAlpha != 0) {
                this.log("Invalid alpha value specified.");
                return false;
            }
            if (saveAlpha == 1 && (color == 10 || color == 12 || color == 121)) {
                this.log("Alpha channel can only be saved for RGB images.");
                return false;
            }
            if (mode != 1 && mode != 0) {
                this.log("Invalid mode value specified.");
                return false;
            }
            if (compression == 2 || compression == 3 || compression == 4) {
                if (color != 12 && color != 121) {
                    this.log("When using CCITT compression, color must be type binary");
                    return false;
                }
                if (saveAlpha == 1) {
                    this.log("When using CCITT compression, alpha must be IMAGE_SAVE_NO_ALPHA");
                    return false;
                }
            }
            if (compression == 7 && (quality < 1 || quality > 100)) {
                quality = 75;
            }
            if (compression == 8 && (quality < 1 || quality > 9)) {
                quality = 6;
            }
            return Document.writeTif(this.handle, page, zoom, saveAlpha, color, file, compression, mode, quality) == 0;
        }
        return false;
    }

    protected void log(String text) {
        System.out.println(text);
    }
}

