/*
 * Decompiled with CFR 0.152.
 */
package com.jmupdf;

import com.jmupdf.JmuPdf;
import com.jmupdf.Page;
import com.jmupdf.PageRect;
import com.jmupdf.interfaces.DocumentTypes;
import com.jmupdf.interfaces.ImageTypes;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.JComponent;

public class PageRenderer
extends JmuPdf
implements ImageTypes,
Runnable,
DocumentTypes {
    private Page page;
    private JComponent component;
    private BufferedImage image;
    private PageRect origin;
    private float zoom;
    private float resolution;
    private int rotate;
    private int color;
    private int transparent;
    private int x;
    private int y;
    private int w;
    private int h;
    private float x0;
    private float y0;
    private float x1;
    private float y1;
    private boolean isPageRendered;
    private boolean isPageRendering;

    public PageRenderer(Page page, float zoom, int rotate, int color) {
        this.page = page;
        this.zoom = zoom;
        this.rotate = rotate;
        this.color = color;
        this.transparent = 0;
        this.setCroppingArea(page.getX(), page.getY(), page.getWidth(), page.getHeight());
    }

    public void setCroppingArea(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.x0 = x;
        this.y0 = y;
        this.x1 = x + w;
        this.y1 = y + h;
        this.origin = new PageRect(this.x0, this.y0, this.x1, this.y1);
        this.isPageRendered = false;
        this.isPageRendering = false;
    }

    public void setCroppingArea(float x0, float y0, float x1, float y1) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        this.x = (int)x0;
        this.y = (int)y0;
        this.w = (int)(x1 - x0);
        this.h = (int)(y1 - y0);
        this.origin = new PageRect(x0, y0, x1, y1);
        this.isPageRendered = false;
        this.isPageRendering = false;
    }

    public void setComponent(JComponent component) {
        this.component = component;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public float getX0() {
        return this.x0;
    }

    public float getY0() {
        return this.y0;
    }

    public float getX1() {
        return this.x1;
    }

    public float getY1() {
        return this.y1;
    }

    public int getNormalizedRotation() {
        int rotate = this.getRotation();
        if (rotate == -1) {
            rotate = this.getPage().getRotation();
        } else if (rotate != 0) {
            rotate += this.getPage().getRotation();
        }
        if ((rotate %= 360) < 0) {
            rotate += 360;
        }
        return rotate;
    }

    public int getRotation() {
        return this.rotate;
    }

    public void setRotation(int rotate) {
        if (this.getRotation() == rotate) {
            return;
        }
        this.rotate = rotate;
        this.isPageRendered = false;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        if (this.getZoom() == zoom) {
            return;
        }
        this.zoom = zoom;
        this.isPageRendered = false;
    }

    public int getColorType() {
        return this.color;
    }

    public void setColorType(int color) {
        if (this.getColorType() == color) {
            return;
        }
        this.color = color;
        this.isPageRendered = false;
    }

    public boolean isTransparent() {
        return this.transparent == 1;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent ? 1 : 0;
        this.isPageRendered = false;
    }

    public float getResolution() {
        return this.resolution;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        if (this.getPage().getPageNumber() == page.getPageNumber() && this.getPage().getDocument().getHandle() == page.getDocument().getHandle()) {
            return;
        }
        this.page = page;
        this.isPageRendered = false;
        this.setCroppingArea(page.getX(), page.getY(), page.getWidth(), page.getHeight());
    }

    public BufferedImage getImage() {
        if (!this.isPageRendered() || this.isPageRendering()) {
            return null;
        }
        return this.image;
    }

    public boolean isPageRendered() {
        return this.isPageRendered;
    }

    public boolean isPageRendering() {
        return this.isPageRendering;
    }

    public void render(boolean wait) {
        if (this.isPageRendering) {
            return;
        }
        if (wait) {
            this.run();
        } else {
            Thread t = new Thread(this);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block29: {
            block27: {
                block28: {
                    if (!this.isPageRendering() && !this.isPageRendered()) break block27;
                    this.isPageRendering = false;
                    if (this.component == null) break block28;
                    JComponent jComponent = this.component;
                    synchronized (jComponent) {
                        this.component.notify();
                        this.component.repaint();
                    }
                }
                return;
            }
            try {
                this.isPageRendering = true;
                this.isPageRendered = false;
                if (this.image != null) {
                    this.image.flush();
                    this.image = null;
                }
                PageRect c = this.zeroRotate(this.origin.getX0(), this.origin.getY0(), this.origin.getX1(), this.origin.getY1(), this.getPage().getRotation());
                if (this.getPage().getDocument().getType() == 0) {
                    c = c.translate(this.getPage().getMediaBox());
                }
                int[] bbox = new int[4];
                Object pixels = PageRenderer.getPixMap(this.getPage().getDocument().getHandle(), this.getPage().getPageNumber(), this.getZoom(), this.getNormalizedRotation(), this.getColorType(), this.transparent, bbox, c.getX0(), c.getY0(), c.getX1(), c.getY1());
                if (pixels != null) {
                    this.x = bbox[0];
                    this.y = bbox[1];
                    this.w = bbox[2];
                    this.h = bbox[3];
                    this.x0 = this.x;
                    this.y0 = this.y;
                    this.x1 = this.x + this.w;
                    this.y1 = this.y + this.h;
                    this.resolution = this.getZoom() * 72.0f;
                    this.createBufferedImage(pixels);
                    if (this.image != null) {
                        this.isPageRendered = true;
                    }
                }
            }
            catch (Exception c) {
                this.isPageRendering = false;
                if (this.component == null) break block29;
                JComponent jComponent = this.component;
                synchronized (jComponent) {
                    this.component.notify();
                    this.component.repaint();
                    break block29;
                }
            }
            catch (OutOfMemoryError e) {
                JComponent jComponent;
                try {
                    this.image = null;
                    System.gc();
                    this.isPageRendering = false;
                    if (this.component == null) break block29;
                    jComponent = this.component;
                }
                catch (Throwable throwable) {
                    this.isPageRendering = false;
                    if (this.component != null) {
                        JComponent jComponent2 = this.component;
                        synchronized (jComponent2) {
                            this.component.notify();
                            this.component.repaint();
                        }
                    }
                    throw throwable;
                }
                synchronized (jComponent) {
                    this.component.notify();
                    this.component.repaint();
                    break block29;
                }
            }
            this.isPageRendering = false;
            if (this.component == null) break block29;
            JComponent jComponent = this.component;
            synchronized (jComponent) {
                this.component.notify();
                this.component.repaint();
            }
        }
    }

    public void dispose() {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
        this.isPageRendered = false;
        this.isPageRendering = false;
    }

    private PageRect zeroRotate(float x0, float y0, float x1, float y1, int rotate) {
        PageRect mb = this.getPage().getMediaBox().rotate(this.getPage().getMediaBox(), rotate);
        PageRect c = new PageRect(x0, y0, x1, y1);
        return c.rotate(mb, -rotate);
    }

    private void createBufferedImage(Object pixels) {
        this.image = this.getColorType() == 12 || this.getColorType() == 121 ? new BufferedImage(this.getWidth(), this.getHeight(), 12) : new BufferedImage(this.getWidth(), this.getHeight(), 2);
        if (this.image != null) {
            WritableRaster raster = this.image.getRaster();
            raster.setDataElements(this.getX(), this.getY(), this.getWidth(), this.getHeight(), pixels);
        }
    }

    protected void log(String text) {
        System.out.println(text);
    }
}

