/*
 * Decompiled with CFR 0.152.
 */
package com.jmupdf;

import com.jmupdf.Document;
import com.jmupdf.Page;
import com.jmupdf.PageRenderer;
import com.jmupdf.exceptions.DocException;
import com.jmupdf.exceptions.DocSecurityException;
import com.jmupdf.pdf.PdfDocument;
import com.jmupdf.xps.XpsDocument;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;

public class PrintServices
implements Printable,
PrintJobListener,
Runnable {
    private Document document;
    private Page page;
    private PageRenderer renderer;
    private DocPrintJob job;
    private Doc simpleDoc;
    private HashPrintRequestAttributeSet printAttributeSet;
    private boolean printJobDone = false;
    private int currentPage = 0;
    private int colorSpace;
    private int rotate;
    private boolean customResolution = false;
    private float zoomFactor = 1.0f;
    private boolean pureBlackWhite = false;
    private boolean ditherBlackWhite = false;
    private final PrintQuality defaultPrintQuality = PrintQuality.NORMAL;
    private final MediaSizeName defualtMediaSize = MediaSizeName.NA_LETTER;
    private final Chromaticity defaultChromacity = Chromaticity.MONOCHROME;
    private OrientationRequested defaultOrientation = OrientationRequested.PORTRAIT;

    public PrintServices(String document, String password) throws DocException, DocSecurityException {
        this.document = new PdfDocument(document, password);
    }

    public PrintServices(Document document) throws DocException {
        if (document.getType() == 0) {
            this.document = ((PdfDocument)document).clone();
        } else if (document.getType() == 1) {
            this.document = ((XpsDocument)document).clone();
        }
        if (this.document == null) {
            throw new DocException("Could not open document for printing");
        }
    }

    public PrintServices(PdfDocument document) throws DocException {
        this.document = document.clone();
        if (this.document == null) {
            throw new DocException("Could not open document for printing");
        }
    }

    public PrintServices(XpsDocument document) throws DocException {
        this.document = document.clone();
        if (this.document == null) {
            throw new DocException("Could not open document for printing");
        }
    }

    public void print(String jobName, String printer, boolean showDialog) {
        this.print(jobName, printer, 1, 1, this.document.getPageCount(), this.defualtMediaSize, this.defaultPrintQuality, this.defaultChromacity, this.defaultOrientation, showDialog);
    }

    public void print(String jobName, String printer, int startPage, int endPage, boolean showDialog) {
        this.print(jobName, printer, 1, startPage, endPage, this.defualtMediaSize, this.defaultPrintQuality, this.defaultChromacity, this.defaultOrientation, showDialog);
    }

    public void print(String jobName, String printer, int copies, boolean showDialog) {
        this.print(jobName, printer, copies, 1, this.document.getPageCount(), this.defualtMediaSize, this.defaultPrintQuality, this.defaultChromacity, this.defaultOrientation, showDialog);
    }

    public void print(String jobName, String printer, int copies, int startPage, int endPage, MediaSizeName media, PrintQuality quality, Chromaticity color, OrientationRequested orientation, boolean showDialog) {
        try {
            Object o;
            HashDocAttributeSet docAttributeSet = new HashDocAttributeSet();
            this.simpleDoc = new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, docAttributeSet);
            this.printAttributeSet = new HashPrintRequestAttributeSet();
            this.printAttributeSet.add(new Copies(copies));
            this.printAttributeSet.add(new JobName(jobName, Locale.getDefault()));
            this.printAttributeSet.add(new PageRanges(startPage, endPage));
            this.printAttributeSet.add(media);
            this.printAttributeSet.add(quality);
            this.printAttributeSet.add(orientation);
            MediaSize mediaSize = MediaSize.getMediaSizeForName(media);
            float[] size = mediaSize.getSize(25400);
            this.printAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, size[0], size[1], 25400));
            docAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, size[0], size[1], 25400));
            PrintService ps = this.getPrinterService(printer);
            if (color.equals(Chromaticity.COLOR)) {
                o = (Chromaticity[])ps.getSupportedAttributeValues(Chromaticity.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, this.printAttributeSet);
                boolean found = false;
                int i = 0;
                while (i < ((Chromaticity[])o).length) {
                    if (o[i].equals(Chromaticity.COLOR)) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    color = Chromaticity.MONOCHROME;
                }
            }
            this.printAttributeSet.add(color);
            if (showDialog) {
                PrinterJob pJob = PrinterJob.getPrinterJob();
                pJob.setPrintService(ps);
                if (!pJob.printDialog(this.printAttributeSet)) {
                    this.dispose();
                    return;
                }
                ps = pJob.getPrintService();
            }
            o = (OrientationRequested)this.printAttributeSet.get(OrientationRequested.class);
            this.printAttributeSet.add(OrientationRequested.PORTRAIT);
            this.rotate = o.equals(OrientationRequested.PORTRAIT) ? 0 : 90;
            Chromaticity c = (Chromaticity)this.printAttributeSet.get(Chromaticity.class);
            this.colorSpace = c.equals(Chromaticity.MONOCHROME) ? (this.pureBlackWhite ? (this.ditherBlackWhite ? 121 : 12) : 10) : 1;
            this.job = ps.createPrintJob();
            this.job.addPrintJobListener(this);
            Thread t = new Thread(this);
            t.start();
        }
        catch (PrinterException e) {
            this.dispose();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.currentPage = pageIndex + 1;
        if (this.currentPage > this.document.getPageCount() || this.printJobDone) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setBackground(Color.WHITE);
        if (this.page == null || this.currentPage != this.page.getPageNumber()) {
            this.page = this.document.getPage(this.currentPage);
            if (!this.customResolution) {
                float z = (float)this.page.getWidth() / (float)pageFormat.getWidth();
                this.zoomFactor = (float)g2.getTransform().getScaleX();
                if (z > 1.0f) {
                    this.zoomFactor /= z;
                }
            }
            if (this.renderer != null) {
                this.renderer.dispose();
            }
            this.renderer = new PageRenderer(this.page, this.zoomFactor, this.rotate, this.colorSpace);
            this.renderer.render(true);
        }
        int x = (int)pageFormat.getImageableX();
        int y = (int)pageFormat.getImageableY();
        int w = this.page.getWidth();
        int h = this.page.getHeight();
        if (w > (int)pageFormat.getImageableWidth()) {
            w = (int)pageFormat.getImageableWidth();
        }
        if (h > (int)pageFormat.getImageableHeight()) {
            h = (int)pageFormat.getImageableHeight();
        }
        g2.setClip(x, y, w, h);
        if (this.renderer.isPageRendered()) {
            g2.drawImage(this.renderer.getImage(), x, y, w, h, null);
        } else {
            FontMetrics fm = g2.getFontMetrics();
            String msg = "Not enough memory to print page " + this.currentPage + ".";
            int sw = fm.stringWidth(msg);
            g2.drawString(msg, x + (w / 2 - sw / 2), y + h / 2);
        }
        g2.dispose();
        return 0;
    }

    public void cancel() {
        CancelablePrintJob cj = (CancelablePrintJob)this.job;
        try {
            cj.cancel();
        }
        catch (PrintException printException) {
            // empty catch block
        }
    }

    public void setCustomResolution(int resolution) {
        if (resolution > 0) {
            this.customResolution = true;
            this.zoomFactor = resolution / 72;
        } else {
            this.customResolution = false;
            this.zoomFactor = 0.0f;
        }
    }

    public void setPureBlackWhite(boolean printBlackWhite, boolean dither) {
        this.pureBlackWhite = printBlackWhite;
        this.ditherBlackWhite = dither;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public boolean isPrintJobDone() {
        return this.printJobDone;
    }

    private void dispose() {
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.document.close();
        this.printJobDone = true;
    }

    private PrintService getPrinterService(String printer) {
        PrintService[] printServices = PrinterJob.lookupPrintServices();
        PrintService printService = null;
        if (printer.trim().length() == 0) {
            printer = this.getDefaultPrinter();
        }
        int i = 0;
        while (i < printServices.length) {
            if (printServices[i].getName().trim().toLowerCase().equals(printer.trim().toLowerCase())) {
                printService = printServices[i];
                break;
            }
            ++i;
        }
        if (printService == null) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        }
        return printService;
    }

    private String getDefaultPrinter() {
        return PrintServiceLookup.lookupDefaultPrintService().getName();
    }

    public void run() {
        try {
            try {
                this.job.print(this.simpleDoc, this.printAttributeSet);
                this.waitForPrintJobDone();
            }
            catch (PrintException printException) {
                this.dispose();
            }
        }
        finally {
            this.dispose();
        }
    }

    public void printDataTransferCompleted(PrintJobEvent pje) {
    }

    public void printJobRequiresAttention(PrintJobEvent pje) {
    }

    public void printJobCompleted(PrintJobEvent pje) {
        this.printJobDone();
    }

    public void printJobFailed(PrintJobEvent pje) {
        this.printJobDone();
    }

    public void printJobCanceled(PrintJobEvent pje) {
        this.printJobDone();
    }

    public void printJobNoMoreEvents(PrintJobEvent pje) {
        this.printJobDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printJobDone() {
        PrintServices printServices = this;
        synchronized (printServices) {
            this.printJobDone = true;
            this.notify();
        }
    }

    public synchronized void waitForPrintJobDone() {
        try {
            while (!this.printJobDone) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

