/*
 * Decompiled with CFR 0.152.
 */
package com.jmupdf.pdf;

import com.jmupdf.JmuPdf;
import com.jmupdf.interfaces.CryptTypes;
import com.jmupdf.pdf.PdfDocument;

public class PdfEncrypt
extends JmuPdf
implements CryptTypes {
    private boolean isEncrypted;
    private boolean canPrint;
    private boolean canModify;
    private boolean canCopy;
    private boolean canNotes;
    private boolean canFillForm;
    private boolean canAccessibility;
    private boolean canAssemble;
    private boolean canPrintQuality;
    private int revision;
    private int length;
    private String method;

    public PdfEncrypt(PdfDocument pdfDoc) {
        int[] data = PdfEncrypt.muPdfEncryptInfo(pdfDoc.getHandle());
        this.isEncrypted = data[0] > 0;
        this.canPrint = data[1] > 0;
        this.canModify = data[2] > 0;
        this.canCopy = data[3] > 0;
        this.canNotes = data[4] > 0;
        this.canFillForm = data[5] > 0;
        this.canAccessibility = data[6] > 0;
        this.canAssemble = data[7] > 0;
        this.canPrintQuality = data[8] > 0;
        this.revision = data[9];
        this.length = data[10];
        if (data[11] == 0) {
            this.method = "NONE";
        } else if (data[11] == 1) {
            this.method = "RC4";
        } else if (data[11] == 2) {
            this.method = "AES";
        } else if (data[11] == 3) {
            this.method = "NONE";
        }
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getLength() {
        return this.length;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean getCanPrint() {
        return this.canPrint;
    }

    public boolean getCanModify() {
        return this.canModify;
    }

    public boolean getCanNotes() {
        return this.canNotes;
    }

    public boolean getCanCopy() {
        return this.canCopy;
    }

    public boolean getCanFillForm() {
        return this.canFillForm;
    }

    public boolean getCanAccessibility() {
        return this.canAccessibility;
    }

    public boolean getCanAssemble() {
        return this.canAssemble;
    }

    public boolean getCanPrintQuality() {
        return this.canPrintQuality;
    }
}

