/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.io.IOException;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;

public class EncryptOptions
implements CommandOption {
    private String userpw = "";
    private String ownerpw = null;
    private int permissions = 0;
    private int encmode = 0;

    public boolean supportsOption(String string) {
        return string.equals("-ownerpw") || string.equals("-userpw") || string.equals("-permissions") || string.equals("-encmode") || string.equals("-encnometadata");
    }

    public boolean setOption(String string, String string2) {
        if (string.equals("-ownerpw")) {
            this.ownerpw = string2;
        } else if (string.equals("-userpw")) {
            this.userpw = string2;
            if (this.ownerpw == null) {
                this.ownerpw = string2;
            }
        } else if (string.equals("-permissions")) {
            String[] stringArray = string2.split(",");
            this.permissions = 0;
            block0: for (String string3 : stringArray) {
                for (int i = 0; i < PdfTweak.permissionTexts.length; ++i) {
                    if (!string3.equals(PdfTweak.permissionTexts[i])) continue;
                    this.permissions += PdfTweak.permissionBits[i];
                    continue block0;
                }
                System.err.println("Skipping invalid permission: " + string3);
            }
        } else {
            this.encmode = Integer.parseInt(string2) + (string.equals("-encnometadata") ? 8 : 0);
        }
        return true;
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        if (this.ownerpw != null) {
            pdfTweak.setEncryption(this.encmode, this.permissions, this.ownerpw.getBytes("ISO-8859-1"), this.userpw.getBytes("ISO-8859-1"));
        }
    }

    public String getSummary() {
        return " -ownerpw                Encrypt PDF and set owner password.\n -userpw                 Encrypt PDF and set user password.\n -permissions            Set file permissions.\n -encmode                Set encryption mode.\n -encnometadata          Set encryption mode and do not encrypt metadata.\n";
    }

    public String getHelp(String string) {
        if (string.equals("-ownerpw")) {
            return " -ownerpw {PASSWORD}\n    Encrypt PDF and set owner password.";
        }
        if (string.equals("-userpw")) {
            return " -userpw {PASSWORD}\n    Encrypt PDF and set user password.";
        }
        if (string.equals("-permissions")) {
            return " -PERMISSIONS {PERMISSION}[,{PERMISSION}[,...]]\n    Set file permissions for encrypted PDF. \n    Permission names are the same as in the GUI.";
        }
        return " -encmode {MODE} -encnometadata {MODE}    Set encryption mode. If -encnometadata is used,\n    metadata is left unencrypted. Available modes:\n        0 = 40-bit RC4 (default)\n        1 = 128-bit RC4\n        2 = 128-bit AES (Acrobat 7.0)";
    }
}

