/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfPageLabels;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;

public class PageNumberOption
implements CommandOption {
    private List<PdfPageLabels.PdfPageLabelFormat> pageLabels = new ArrayList<PdfPageLabels.PdfPageLabelFormat>();
    private boolean noLabels = false;

    public boolean supportsOption(String string) {
        return string.equals("-pagenumbers") || string.equals("-loadpagenumbers");
    }

    public boolean setOption(String string, String string2) throws IOException {
        if (string.equals("-loadpagenumbers")) {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));
            while ((string3 = bufferedReader.readLine()) != null) {
                this.pageLabels.add(this.parsePageLabel(string3));
            }
            bufferedReader.close();
        } else if (string2.equals("-")) {
            this.noLabels = true;
        } else {
            this.pageLabels.add(this.parsePageLabel(string2));
        }
        return true;
    }

    private PdfPageLabels.PdfPageLabelFormat parsePageLabel(String string) {
        Pattern pattern = Pattern.compile("([0-9]+)=(.*:)?([0-9]+)([aAiI-]?)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new RuntimeException("Cannot parse page label: " + string);
        }
        String string2 = matcher.group(2);
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 0) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n = 0;
        if (matcher.group(4).length() > 0) {
            n = "xIiAa-".indexOf(matcher.group(4).charAt(0));
        }
        return new PdfPageLabels.PdfPageLabelFormat(Integer.parseInt(matcher.group(1)), n, string2, Integer.parseInt(matcher.group(3)));
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        if (this.noLabels) {
            pdfTweak.setPageNumbers(new PdfPageLabels.PdfPageLabelFormat[0]);
        }
        if (this.pageLabels.size() > 0) {
            pdfTweak.setPageNumbers(this.pageLabels.toArray(new PdfPageLabels.PdfPageLabelFormat[this.pageLabels.size()]));
        }
    }

    public String getSummary() {
        return " -pagenumbers            Add PDF page number format(s)\n -loadpagenumbers        Load PDF page number format from CSV file\n";
    }

    public String getHelp(String string) {
        return " -pagenumbers {NUMBERFORMAT}\n    Add a page number format.\n -pagenumbers -\n    Remove all page number formats.\n -loadpagenumbers {FILE}\n    Load page numbers from text file.\n\n A bookmark looks like this:\n    page=[prefix:]pagenum[type]\n  [page] is the page number of the first page where the format\n         is used.\n  [pagenum] is the number that this page should get\n  [type] is the number type: nothing or one of 'I i A a -'.\n  [prefix] if given (separated by a colon) is the prefix before\n         the number.\n\n Examples:\n 1=Page :1\n 10=10A\n 20=Chapter:1I\n 100=Appendix:100-";
    }
}

