/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.io.IOException;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;

public class RotateOption
implements CommandOption {
    private int portraitCount = 0;
    private int landscapeCount = 0;
    private boolean explicit = false;
    private boolean set = false;

    public boolean supportsOption(String string) {
        return string.matches("-rot(exp|ate(explicitly)?)?");
    }

    public boolean setOption(String string, String string2) {
        if (this.set) {
            System.err.println("Error: more than one -rotate option used.");
            return false;
        }
        if (string.contains("exp")) {
            this.explicit = true;
        }
        if (string2.length() == 1) {
            this.portraitCount = this.landscapeCount = this.fromchar(string2.charAt(0));
        } else {
            this.portraitCount = this.fromchar(string2.charAt(0));
            this.landscapeCount = this.fromchar(string2.charAt(1));
        }
        this.set = true;
        return true;
    }

    private int fromchar(char c) {
        switch (c) {
            case '0': 
            case 'K': 
            case 'k': {
                return 0;
            }
            case '1': 
            case 'R': 
            case 'r': {
                return 1;
            }
            case '2': 
            case 'U': 
            case 'u': {
                return 2;
            }
            case '3': 
            case 'L': 
            case 'l': {
                return 3;
            }
        }
        System.err.println("Unknown rotation \"" + c + "\", ignoring.");
        return 0;
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws DocumentException, IOException {
        if (this.portraitCount != 0 || this.landscapeCount != 0) {
            pdfTweak.rotatePages(this.portraitCount, this.landscapeCount);
        }
        if (this.explicit) {
            pdfTweak.removeRotation();
        }
    }

    public String getSummary() {
        return " -rot[ate]               Rotate pages, optionally separately for portrait and\n                         landscape.\n -rot[ate]exp[licitly]   The same, but change real content and not the page's\n                         /Rotate attribute.\n";
    }

    public String getHelp(String string) {
        String string2 = "\n    If only one value is given, it is used for both portrait and\n    landscape pages.\n    \n    Available options for {X} and {Y}:\n        K, k, or 0: Keep page (rotate 0 degrees)\n        R, r, or 1: Rotate right (rotate 90 degrees)\n        U, u, or 2: Turn upside down (rotate 180 degrees)\n        L, l, or 3: Rotate left (rotate 270 degrees)\n    \n    Example: -rotate KL\n        Rotate all landscape pages left, so that all pages will be portrait\n        afterwards.";
        if (string.contains("exp")) {
            return " -rot[ate]exp[licitly] {X}{Y}\n    Rotate portrait pages by {X} and landscape pages by {Y}.\n    This will change real content (and destroy interactive features)\n    but will not cause problems with tools that do not understand the /Rotate\n    attribute. Can also be used to remove the rotate attribute from a file\n    while keeping its appearance constant (use 'K' rotation for that).\n" + string2;
        }
        return " -rot[ate] {X}{Y}\n    Rotate portrait pages by {X} and landscape pages by {Y}.\n    This will change the /Rotation option (and keep interactive features)\n    but might cause problems with tools that do not understand this option.\n" + string2;
    }
}

